% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{aux.shortestpath}
\alias{aux.shortestpath}
\title{Find shortest path using Floyd-Warshall algorithm}
\usage{
aux.shortestpath(dist)
}
\arguments{
\item{dist}{either an \code{(n-by-n)} matrix or a \code{dist} class object.}
}
\value{
an \code{(n-by-n)} matrix containing pairwise shortest path.
}
\description{
This is a fast implementation of Floyd-Warshall algorithm to find the
shortest path in a pairwise sense using 'RcppArmadillo'. A logical input
is also accepted.
}
\examples{
## Generate 10-sample data
X = aux.gensamples(n=10)

## Find knn graph with k=3
Xgraph = aux.graphnbd(X,type=c("knn",3))

## Separately use binarized and real distance matrices
W1 = aux.shortestpath(Xgraph$mask)
W2 = aux.shortestpath(Xgraph$dist)

par(mfrow=c(1,2))
image(W1); title("from binarized")
image(W2); title("from Euclidean distance")

}
\references{
Floyd, R.W. (1962) \emph{Algorithm 97: Shortest Path}. Commincations of the ACMS, Vol.5(6):345.
}
\author{
Kisung You
}
