#' Dimension Reduction and Estimation Methods
#'
#' \pkg{Rdimtools} is an R implementation of a number of dimension reduction and estimation methods
#' implemented using \pkg{RcppArmadillo} for efficient computations. Please see the section below for
#' the complete composition of this package and what we can provide in a unifying interface across many
#' methods.
#'
#' @section Composition of the package:
#' The package consists of three families of functions whose names start with \code{do.},\code{est.} and \code{aux.}
#' for performing dimension reduction/manifold learning, estimating intrinsic dimension, and some efficient
#' implementations of other useful methods respectively.
#'
#' \bold{\code{do.}} functions are for dimension reduction (or, \emph{manifold learning}) methods.
#' A simple taxonomy of the methods would be to categorize based on the linearity of
#' embedding mappings. For \emph{linear} methods, we have
#' \itemize{
#'   \item \code{\link{do.fa}} for (Exploratory) Factor Analysis.
#'   \item \code{\link{do.ica}} for Independent Component Analysis.
#'   \item \code{\link{do.lda}} for Linear Discriminant Analysis.
#'   \item \code{\link{do.lmds}} for Landmark Multidimensional Scaling.
#'   \item \code{\link{do.lpp}} for Locality Preserving Embedding (LPP)
#'   \item \code{\link{do.mds}} for Multidimensional Scaling.
#'   \item \code{\link{do.npe}} for Neighborhood Preserving Embedding.
#'   \item \code{\link{do.pca}} for Principal Component Analysis.
#'   \item \code{\link{do.rndproj}} for Random Projection.
#' }
#' Also, we have \emph{nonlinear} methods implemented
#' \itemize{
#'   \item \code{\link{do.cisomap}} for Conformal Isometric Feature Mapping.
#'   \item \code{\link{do.dm}} for Diffusion Maps.
#'   \item \code{\link{do.isomap}} for Isometric Feature Mapping.
#'   \item \code{\link{do.keca}} for Kernel Entropy Component Analysis.
#'   \item \code{\link{do.kpca}} for Kernel Principal Component Analysis.
#'   \item \code{\link{do.lapeig}} for Laplacian Eigenmaps.
#'   \item \code{\link{do.lisomap}} for Landmark Isometric Feature Mapping.
#'   \item \code{\link{do.lle}} for Locally Linear Embedding.
#'   \item \code{\link{do.ltsa}} for Local Tangent Space Alignment.
#'   \item \code{\link{do.mvu}} for Maximum Variance Unfolding / Semidefinite Embedding.
#'   \item \code{\link{do.plp}} for Piecewise Laplacian Projection.
#'   \item \code{\link{do.ree}} for Robust Euclidean Embedding.
#'   \item \code{\link{do.sammon}} for Sammon Mapping.
#'   \item \code{\link{do.sne}} for Stochastic Neighbor Embedding.
#'   \item \code{\link{do.tsne}} for t-distributed Stochastic Neighbor Embedding.
#' }
#'
#' Secondly, \bold{\code{est.}} family of functions are for intrinsic dimension estimation methods, including
#' \itemize{
#'   \item \code{\link{est.boxcount}} for Box-Counting Dimension.
#'   \item \code{\link{est.correlation}} for Correlation Dimension.
#' }
#'
#' Finally, there are some auxiliary functions (\bold{\code{aux.}} family),
#' \itemize{
#'   \item \code{\link{aux.gensamples}} to generate samples from predefined shapes.
#'   \item \code{\link{aux.graphnbd}} to make a neighborhood graph given certain criteria.
#'   \item \code{\link{aux.kernelcov}} that computes a centered gram matrix with 20 kernels supported.
#'   \item \code{\link{aux.preprocess}} to perform preprocessing of centering, decorrelating, or whitening.
#'   \item \code{\link{aux.shortestpath}} is an efficient implementation of Floyd-Warshall algorithm.
#' }
#'
#' @docType package
#' @name Rdimtools
#' @aliases Rdimtools-package
#' @import Rcsdp
#' @import Rdpack
#' @importFrom Rlinsolve lsolve.bicgstab
#' @importFrom Rtsne Rtsne
#' @importFrom stats dist cov rnorm runif
#' @importFrom graphics par image plot
#' @importFrom Rcpp evalCpp
#' @useDynLib Rdimtools
NULL


