\name{reformat_code}
\alias{reformat_code}
\title{Format the code in the usage and examples sections}
\usage{reformat_code(path, section = c("examples", "usage"), 
    ...)
}
\description{
This function can polish the Rd files generated by roxygen mainly
in two sections: usage and examples. By default, roxygen will omit
the spaces and indent in the code, which makes the code
(especially in the examples section) hard to read. It uses the
function \code{\link[formatR]{tidy.source}} in the package
\pkg{formatR}.}
\details{If the macro \code{"\dontrun"} is detected in the Rd file, this
function will use an unstable way to reformat the example and
usage sections, which might destroy your original Rd (e.g. the
subsection macro can be mangled); otherwise it will use ordinary
text-processing techniques to deal with these sections and
generally will not affect other sections. However, neither way is
absolutely safe. Whenever you run into troubles, just try to turn
off reformatting.}
\value{This function returns \code{TRUE} if the macro
\code{"\dontrun"} is detected in the Rd; \code{FALSE} if not
deteced; and \code{NULL} if the package \pkg{formatR} is not
installed (as a side effect, the original Rd file will be updated)}
\author{Yihui Xie <\url{http://yihui.name}>}
\seealso{\code{\link[formatR]{tidy.source}}}
\arguments{\item{path}{the path of the Rd file}
\item{section}{the sections in the Rd file to (re)format (the only
possible choices are \code{"examples"} and \code{"usage"})}
\item{...}{other arguments passed to \code{tidy.source}}
}
\examples{rd.file = system.file("examples", "reformat_code_demo.Rd", 
    package = "Rd2roxygen")
file.copy(rd.file, tempdir())
fmt.file = file.path(tempdir(), "reformat_code_demo.Rd")

if (interactive()) file.show(fmt.file)  ## show the raw Rd
reformat_code(fmt.file)
if (interactive()) file.show(fmt.file)  ## the formatted Rd}

