% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtn.R
\name{dtn}
\alias{dtn}
\title{Truncated Normal Distribution Density}
\usage{
dtn(.x = 0, .mean = rep(0, length(.x)), .sd = rep(1, length(.x)),
  .low = rep(-Inf, length(.x)), .high = rep(Inf, length(.x)),
  .checks = TRUE)
}
\arguments{
\item{.x}{Length K vector of the points at which to evaluate the density}

\item{.mean}{Length K vector with the means of the K Normal distributions
*prior* to truncation}

\item{.sd}{Length K vector with the standard deviations of the K Normal
distributions *prior* to truncation}

\item{.low}{Length K vector with the lower truncation bound of the K Normal
distributions *prior* to truncation}

\item{.high}{Length K vector with the upper truncation bound of the K Normal
distributions *prior* to truncation}

\item{.checks}{Logical indicating whether inputs and outputs should be
checked and either stop (for bad inputs) or warn (for likely bad outputs)}
}
\value{
Length K vector with the entropies associated with each of the K
    Truncated Normal distributions
}
\description{
Calculate density of Truncated Normal distributions
}
\examples{
lows <- c(-1, 5, -100, 4, 4, -100, 7)
highs <- c(1, 100, 10, 7, 4.1, 100, 100)
dtn(.x = rep(0, length(lows)),
    .mean = rep(0, length(lows)),
    .sd = rep(1, length(lows)),
    .high = highs
    )
}
\author{
Jonathan Olmsted
}
