% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapfunc.R
\name{wakefield_pp}
\alias{wakefield_pp}
\title{compute posterior probabilities using Wakefield's approximate Bayes Factors
\code{wakefield_pp} computes posterior probabilities for a given SNP to be causal for a given SNP under the assumption of a single causal variant.}
\usage{
wakefield_pp(beta, se, pi_i = 1e-04, sd.prior = 0.2)
}
\arguments{
\item{beta}{a vector of effect sizes (\eqn{\beta}) from a quantitative trait GWAS}

\item{se}{vector of standard errors of effect sizes (\eqn{\beta})}

\item{pi_i}{a scalar representing the prior probability (DEFAULT \eqn{1 \times 10^{-4}})}

\item{sd.prior}{a scalar representing our prior expectation of \eqn{\beta} (DEFAULT 0.2).
The method assumes a normal prior on the population log relative risk centred at 0 and the DEFAULT
value sets the variance of this distribution to 0.04, equivalent to a 95\\%  belief that the true relative risk
is in the range of 0.66-1.5 at any causal variant.}
}
\value{
a vector of posterior probabilities.
}
\description{
This function was adapted from its namesake in cupcake package (github.com/ollyburren/cupcake/) to no longer require allele frequencies.
}
\author{
Olly Burren, Chris Wallace, Guillermo Reales
}
