% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RacViewer.R
\name{RacViewer}
\alias{RacViewer}
\title{Create a RacViewer widget}
\usage{
RacViewer(
  map,
  show_procrustes = FALSE,
  show_group_legend = FALSE,
  options = list(),
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{map}{The map data object}

\item{show_procrustes}{should procrustes lines be shown}

\item{show_group_legend}{Show an interactive legend detailing different
groups as set by \code{agGroups()} and \code{srGroups()}}

\item{options}{A named list of viewer options supplied to
\code{racviewer.options()}}

\item{width}{Width of the widget}

\item{height}{Height of the widget}

\item{elementId}{DOM element ID}
}
\value{
An object of class htmlwidget that will intelligently print itself
into HTML in a variety of contexts including the R console, within R
Markdown documents, and within Shiny output bindings.
}
\description{
This creates an html widget for viewing antigenic maps.
}
\seealso{
Other functions to view maps: 
\code{\link{RacViewer.options}()},
\code{\link{export_viewer}()},
\code{\link{ggplot.acmap}()},
\code{\link{mapGadget}()},
\code{\link{plot.acmap}()},
\code{\link{setLegend}()},
\code{\link{view.acmap}()},
\code{\link{view.default}()},
\code{\link{view}()}
}
\concept{functions to view maps}
