% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{checkHemisphering}
\alias{checkHemisphering}
\title{Check for hemisphering or trapped points}
\usage{
checkHemisphering(
  map,
  optimization_number = 1,
  grid_spacing = 0.25,
  stress_lim = 0.1,
  options = list()
)
}
\arguments{
\item{map}{The acmap data object}

\item{optimization_number}{The map optimization number}

\item{grid_spacing}{When doing a grid search of more optimal point positions
the grid spacing to use}

\item{stress_lim}{The stess difference to use when classifying a point as
"hemisphering" or not}

\item{options}{A named list of options to pass to \code{RacOptimizer.options()}}
}
\value{
Returns a data frame with information on any points that were found
to be hemisphering or trapped.
}
\description{
Check for hemisphering or trapped points
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}
}
\concept{map diagnostic functions}
