% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotPearsonRes}
\alias{plotPearsonRes}
\title{Function for plotting the variance of Pearson residuals}
\usage{
plotPearsonRes(y, log = FALSE, ...)
}
\arguments{
\item{y}{List object returned by the \code{compNoise} or \code{pruneKnn} function (if run with \code{regNB=TRUE}).}

\item{log}{logical. If \code{TRUE} then the y-axis is log-transformed. Default is \code{FALSE}.}

\item{...}{Additional arguments for \code{plot}.}
}
\value{
None
}
\description{
This function plots the variance versus the mean of the Pearson residuals obtained by the negative binomial regression computed by the function \code{compY} if \code{regNB} is \code{TRUE}. A local regression is also shown.
}
\examples{
res <- pruneKnn(intestinalDataSmall,no_cores=1)
plotPearsonRes(res,log=TRUE)
}
