% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{baseLineVar}
\alias{baseLineVar}
\title{Baseline gene expression variability}
\usage{
baseLineVar(x, y)
}
\arguments{
\item{x}{mean expression. The corresponding corrected variance is returned.}

\item{y}{object returned by \code{compNoise}, \code{noiseBaseFit}, \code{pruneKnn}  or \code{fitBackVar}. Depending on the input the funtion returns either
the background variability (for \code{pruneKnn} or \code{fitBackVar}) or the base line variability.}
}
\value{
Base line (or background) variability.
}
\description{
This function returns the base line variability as a function of the
}
\examples{
y <- noiseBaseFit(intestinalDataSmall,step=.01,thr=.05)
x <- apply(intestinalDataSmall,1,mean)
baseLineVar(x,y)
}
