/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class AddUserFields
extends Filter
implements OptionHandler,
EnvironmentHandler,
UnsupervisedFilter,
WeightedInstancesHandler,
WeightedAttributesHandler {
    private static final long serialVersionUID = -2761427344847891585L;
    protected List<AttributeSpec> m_attributeSpecs = new ArrayList<AttributeSpec>();
    protected transient Environment m_env;

    public String globalInfo() {
        return "A filter that adds new attributes with user specified type and constant value. Numeric, nominal, string and date attributes can be created. Attribute name, and value can be set with environment variables. Date attributes can also specify a formatting string by which to parse the supplied date value. Alternatively, a current time stamp can be specified by supplying the special string \"now\" as the value for a date attribute.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void clearAttributeSpecs() {
        if (this.m_attributeSpecs == null) {
            this.m_attributeSpecs = new ArrayList<AttributeSpec>();
        }
        this.m_attributeSpecs.clear();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tNew field specification (name@type:value).\n\t Environment variables may be used for any/all parts of the\n\tspecification. Type can be one of (numeric, nominal, string or date).\n\tThe value for date be a specific date string or the special string\n\t\"now\" to indicate the current date-time. A specific date format\n\tstring for parsing specific date values can be specified by suffixing\n\tthe type specification - e.g. \"myTime@date:MM-dd-yyyy@08-23-2009\".This option may be specified multiple times", "A", 1, "-A <name@type@value>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.clearAttributeSpecs();
        String attS = "";
        while ((attS = Utils.getOption('A', options)).length() > 0) {
            this.addAttributeSpec(attS);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (int i = 0; i < this.m_attributeSpecs.size(); ++i) {
            options.add("-A");
            options.add(this.m_attributeSpecs.get(i).toStringInternal());
        }
        if (options.size() == 0) {
            return new String[0];
        }
        return options.toArray(new String[1]);
    }

    public void addAttributeSpec(String spec) {
        AttributeSpec newSpec = new AttributeSpec(spec);
        this.m_attributeSpecs.add(newSpec);
    }

    public String attributeSpecsTipText() {
        return "Specifications of the new attributes to create";
    }

    public void setAttributeSpecs(List<AttributeSpec> specs) {
        this.m_attributeSpecs = specs;
    }

    public List<AttributeSpec> getAttributeSpecs() {
        return this.m_attributeSpecs;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() == null) {
            this.setOutputFormat();
        }
        Instance inst = (Instance)instance.copy();
        this.copyValues(inst, true, inst.dataset(), this.outputFormatPeek());
        this.convertInstance(inst);
        return true;
    }

    protected void convertInstance(Instance instance) {
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            vals[i] = instance.value(i);
        }
        Instances outputFormat = this.getOutputFormat();
        for (int i = instance.numAttributes(); i < this.outputFormatPeek().numAttributes(); ++i) {
            String nomVal;
            AttributeSpec spec = this.m_attributeSpecs.get(i - instance.numAttributes());
            Attribute outAtt = outputFormat.attribute(i);
            if (outAtt.isDate()) {
                vals[i] = spec.getDateValue().getTime();
                continue;
            }
            if (outAtt.isNumeric()) {
                vals[i] = spec.getNumericValue();
                continue;
            }
            if (outAtt.isNominal()) {
                nomVal = spec.getNominalOrStringValue();
                vals[i] = outAtt.indexOfValue(nomVal);
                continue;
            }
            nomVal = spec.getNominalOrStringValue();
            vals[i] = outAtt.addStringValue(nomVal);
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(outputFormat);
        this.push(inst, false);
    }

    protected void setOutputFormat() {
        int i;
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        Instances inputF = this.getInputFormat();
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        for (i = 0; i < inputF.numAttributes(); ++i) {
            newAtts.add((Attribute)inputF.attribute(i).copy());
        }
        for (i = 0; i < this.m_attributeSpecs.size(); ++i) {
            AttributeSpec a = this.m_attributeSpecs.get(i);
            a.init(this.m_env);
            String type = a.getResolvedType();
            Attribute newAtt = null;
            if (type.toLowerCase().startsWith("date")) {
                String format = a.getDateFormat();
                if (format == null) {
                    format = "yyyy-MM-dd'T'HH:mm:ss";
                }
                newAtt = new Attribute(a.getResolvedName(), format);
            } else if (type.toLowerCase().startsWith("string")) {
                newAtt = new Attribute(a.getResolvedName(), (List<String>)null);
            } else if (type.toLowerCase().startsWith("nominal")) {
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(a.getResolvedValue());
                newAtt = new Attribute(a.getResolvedName(), vals);
            } else {
                newAtt = new Attribute(a.getResolvedName());
            }
            newAtts.add(newAtt);
        }
        Instances outputFormat = new Instances(inputF.relationName(), newAtts, 0);
        outputFormat.setClassIndex(inputF.classIndex());
        this.setOutputFormat(outputFormat);
    }

    public static void main(String[] argv) {
        AddUserFields.runFilter(new AddUserFields(), argv);
    }

    public static class AttributeSpec
    implements Serializable {
        private static final long serialVersionUID = -617328946241474608L;
        protected String m_name = "";
        protected String m_value = "";
        protected String m_type = "";
        protected String m_nameS;
        protected String m_valueS;
        protected String m_typeS;
        protected SimpleDateFormat m_dateFormat;
        protected Date m_parsedDate;

        public AttributeSpec() {
        }

        public AttributeSpec(String spec) {
            this.parseFromInternal(spec);
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void setType(String type) {
            this.m_type = type;
        }

        public String getType() {
            return this.m_type;
        }

        public void setValue(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getResolvedName() {
            return this.m_nameS;
        }

        public String getResolvedValue() {
            return this.m_valueS;
        }

        public String getResolvedType() {
            return this.m_typeS;
        }

        public String getDateFormat() {
            if (this.m_dateFormat != null) {
                return this.m_dateFormat.toPattern();
            }
            return null;
        }

        public Date getDateValue() {
            if (this.m_parsedDate != null) {
                return this.m_parsedDate;
            }
            if (this.getResolvedType().toLowerCase().startsWith("date")) {
                return new Date();
            }
            return null;
        }

        public double getNumericValue() {
            if (this.getResolvedType().toLowerCase().startsWith("numeric")) {
                return Double.parseDouble(this.getResolvedValue());
            }
            return Utils.missingValue();
        }

        public String getNominalOrStringValue() {
            if (this.getResolvedType().toLowerCase().startsWith("nominal") || this.getResolvedType().toLowerCase().startsWith("string")) {
                return this.getResolvedValue();
            }
            return null;
        }

        protected void parseFromInternal(String spec) {
            String[] parts = spec.split("@");
            if (parts.length > 0) {
                this.m_name = parts[0].trim();
            }
            if (parts.length > 1) {
                this.m_type = parts[1].trim();
            }
            if (parts.length > 2) {
                this.m_value = parts[2].trim();
            }
        }

        public void init(Environment env) {
            this.m_nameS = this.m_name;
            this.m_typeS = this.m_type;
            this.m_valueS = this.m_value;
            try {
                this.m_nameS = env.substitute(this.m_nameS);
                this.m_typeS = env.substitute(this.m_typeS);
                this.m_valueS = env.substitute(this.m_valueS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_typeS.toLowerCase().startsWith("date") && this.m_typeS.indexOf(":") > 0) {
                String format = this.m_typeS.substring(this.m_typeS.indexOf(":") + 1, this.m_typeS.length());
                this.m_dateFormat = new SimpleDateFormat(format);
                if (!this.m_valueS.toLowerCase().equals("now")) {
                    try {
                        this.m_parsedDate = this.m_dateFormat.parse(this.m_valueS);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Date value \"" + this.m_valueS + " \" can't be parsed with formatting string \"" + format + "\"");
                    }
                }
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("Name: ").append(this.m_name).append(" ");
            String type = this.m_type;
            if (type.toLowerCase().startsWith("date") && type.indexOf(":") > 0) {
                type = type.substring(0, type.indexOf(":"));
                String format = this.m_type.substring(this.m_type.indexOf(":1", this.m_type.length()));
                buff.append("Type: ").append(type).append(" [").append(format).append("] ");
            } else {
                buff.append("Type: ").append(type).append(" ");
            }
            buff.append("Value: ").append(this.m_value);
            return buff.toString();
        }

        public String toStringInternal() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_name).append("@").append(this.m_type).append("@").append(this.m_value);
            return buff.toString();
        }
    }
}

