/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.beans.OffscreenChartRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOffscreenChartRenderer
implements OffscreenChartRenderer {
    protected List<Instances> splitToClasses(Instances insts, int classIndex) {
        int i;
        ArrayList<Instances> newSeries = new ArrayList<Instances>();
        Instances[] classes = new Instances[insts.attribute(classIndex).numValues()];
        for (i = 0; i < classes.length; ++i) {
            classes[i] = new Instances(insts, 0);
            classes[i].setRelationName(insts.attribute(classIndex).value(i));
        }
        for (i = 0; i < insts.numInstances(); ++i) {
            Instance current = insts.instance(i);
            classes[(int)current.value(classIndex)].add((Instance)current.copy());
        }
        for (i = 0; i < classes.length; ++i) {
            newSeries.add(classes[i]);
        }
        return newSeries;
    }

    @Override
    public String optionsTipTextHTML() {
        return "<html><ul><li>No options for this renderer</li></ul></html>";
    }

    protected String getOption(List<String> options, String toGet) {
        String value = null;
        if (options == null) {
            return null;
        }
        for (String option : options) {
            if (!option.startsWith(toGet)) continue;
            String[] parts = option.split("=");
            if (parts.length != 2) {
                return "";
            }
            value = parts[1];
            break;
        }
        return value;
    }

    protected int getIndexOfAttribute(Instances insts, String attName) {
        Attribute att;
        if (attName == null) {
            return -1;
        }
        if (attName.equalsIgnoreCase("/last")) {
            return insts.numAttributes() - 1;
        }
        if (attName.equalsIgnoreCase("/first")) {
            return 0;
        }
        if (attName.startsWith("/")) {
            String numS = attName.replace("/", "");
            try {
                int index = Integer.parseInt(numS);
                if (--index >= 0 && index < insts.numAttributes()) {
                    return index;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((att = insts.attribute(attName)) != null) {
            return att.index();
        }
        return -1;
    }
}

