/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.beancontext.BeanContextSupport;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.converters.DatabaseLoader;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Loader;
import weka.gui.sql.SqlViewer;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;

public class SQLViewerPerspective
extends JPanel
implements KnowledgeFlowApp.KFPerspective {
    private static final long serialVersionUID = 3684166225482042972L;
    protected KnowledgeFlowApp.MainKFPerspective m_mainPerspective;
    protected SqlViewer m_viewer;
    protected JButton m_newFlowBut;

    public SQLViewerPerspective() {
        this.setLayout(new BorderLayout());
        this.m_viewer = new SqlViewer(null);
        this.add((Component)this.m_viewer, "Center");
        this.m_newFlowBut = new JButton("New Flow");
        this.m_newFlowBut.setToolTipText("Set up a new Knowledge Flow with the current connection and query");
        JPanel butHolder = new JPanel();
        butHolder.add(this.m_newFlowBut);
        this.add((Component)butHolder, "South");
        this.m_newFlowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SQLViewerPerspective.this.m_mainPerspective != null) {
                    SQLViewerPerspective.this.newFlow();
                }
            }
        });
        this.m_newFlowBut.setEnabled(false);
        this.m_viewer.addConnectionListener(new ConnectionListener(){

            public void connectionChange(ConnectionEvent evt) {
                if (evt.getType() == 1) {
                    SQLViewerPerspective.this.m_newFlowBut.setEnabled(false);
                } else {
                    SQLViewerPerspective.this.m_newFlowBut.setEnabled(true);
                }
            }
        });
    }

    protected void newFlow() {
        this.m_newFlowBut.setEnabled(false);
        String user = this.m_viewer.getUser();
        String password = this.m_viewer.getPassword();
        String uRL = this.m_viewer.getURL();
        String query = this.m_viewer.getQuery();
        if (query == null) {
            query = "";
        }
        try {
            DatabaseLoader dbl = new DatabaseLoader();
            dbl.setUser(user);
            dbl.setPassword(password);
            dbl.setUrl(uRL);
            dbl.setQuery(query);
            BeanContextSupport bc = new BeanContextSupport();
            bc.setDesignTime(true);
            Loader loaderComp = new Loader();
            bc.add(loaderComp);
            loaderComp.setLoader(dbl);
            KnowledgeFlowApp singleton = KnowledgeFlowApp.getSingleton();
            this.m_mainPerspective.addTab("DBSource");
            BeanInstance beanI = new BeanInstance((JComponent)this.m_mainPerspective.getBeanLayout(this.m_mainPerspective.getNumTabs() - 1), loaderComp, 50, 50, this.m_mainPerspective.getNumTabs() - 1);
            Vector beans = BeanInstance.getBeanInstances(this.m_mainPerspective.getNumTabs() - 1);
            Vector connections = BeanConnection.getConnections(this.m_mainPerspective.getNumTabs() - 1);
            singleton.integrateFlow(beans, connections, true, false);
            singleton.setActivePerspective(0);
            this.m_newFlowBut.setEnabled(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setInstances(Instances insts) throws Exception {
    }

    public boolean acceptsInstances() {
        return false;
    }

    public String getPerspectiveTitle() {
        return "SQL Viewer";
    }

    public String getPerspectiveTipText() {
        return "Explore database tables with SQL";
    }

    public Icon getPerspectiveIcon() {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource("weka/gui/beans/icons/database.png");
        if (imageURL != null) {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return new ImageIcon(pic);
    }

    public void setActive(boolean active) {
    }

    public void setLoaded(boolean loaded) {
    }

    public void setMainKFPerspective(KnowledgeFlowApp.MainKFPerspective main) {
        this.m_mainPerspective = main;
    }

    public static void main(String[] args) {
        final JFrame jf = new JFrame();
        jf.getContentPane().setLayout(new BorderLayout());
        SQLViewerPerspective p = new SQLViewerPerspective();
        jf.getContentPane().add((Component)p, "Center");
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                jf.dispose();
                System.exit(0);
            }
        });
        jf.setSize(800, 600);
        jf.setVisible(true);
    }
}

