/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.gui.JTableHelper;
import weka.gui.sql.QueryPanel;
import weka.gui.sql.ResultSetTable;
import weka.gui.sql.ResultSetTableModel;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class ResultPanel
extends JPanel
implements QueryExecuteListener,
ChangeListener {
    private static final long serialVersionUID = 278654800344034571L;
    protected JFrame m_Parent;
    protected HashSet m_Listeners;
    protected QueryPanel m_QueryPanel;
    protected JTabbedPane m_TabbedPane;
    protected JButton m_ButtonClose = new JButton("Close");
    protected JButton m_ButtonCloseAll = new JButton("Close all");
    protected JButton m_ButtonCopyQuery = new JButton("Re-use query");
    protected JButton m_ButtonOptWidth = new JButton("Optimal width");
    protected int m_NameCounter;

    public ResultPanel(JFrame parent) {
        this.m_Parent = parent;
        this.m_QueryPanel = null;
        this.m_NameCounter = 0;
        this.m_Listeners = new HashSet();
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(0, 200));
        this.m_TabbedPane = new JTabbedPane(3);
        this.m_TabbedPane.addChangeListener(this);
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "Center");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel2.add((Component)panel3, "Center");
        JPanel panel4 = new JPanel(new BorderLayout());
        panel3.add((Component)panel4, "Center");
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.close();
            }
        });
        panel.add((Component)this.m_ButtonClose, "North");
        this.m_ButtonCloseAll.setMnemonic('a');
        this.m_ButtonCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.closeAll();
            }
        });
        panel2.add((Component)this.m_ButtonCloseAll, "North");
        this.m_ButtonCopyQuery.setMnemonic('Q');
        this.m_ButtonCopyQuery.setToolTipText("Copies the query of the currently selected tab into the query field.");
        this.m_ButtonCopyQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.copyQuery();
            }
        });
        panel3.add((Component)this.m_ButtonCopyQuery, "North");
        this.m_ButtonOptWidth.setMnemonic('p');
        this.m_ButtonOptWidth.setToolTipText("Calculates the optimal column width for the current table.");
        this.m_ButtonOptWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.calcOptimalWidth();
            }
        });
        panel4.add((Component)this.m_ButtonOptWidth, "North");
        panel4.add((Component)new JLabel(" "), "Center");
        panel4.add((Component)new JLabel(" "), "South");
        this.setButtons();
    }

    public void clear() {
        this.closeAll();
    }

    public void setFocus() {
        this.m_TabbedPane.requestFocus();
    }

    protected void setButtons() {
        int index = this.m_TabbedPane.getSelectedIndex();
        this.m_ButtonClose.setEnabled(index > -1);
        this.m_ButtonCloseAll.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_ButtonCopyQuery.setEnabled(index > -1);
        this.m_ButtonOptWidth.setEnabled(index > -1);
    }

    protected String getNextTabName() {
        ++this.m_NameCounter;
        return "Query" + this.m_NameCounter;
    }

    @Override
    public void queryExecuted(QueryExecuteEvent evt) {
        if (evt.failed()) {
            return;
        }
        if (!evt.hasResult()) {
            return;
        }
        try {
            ResultSetTable table = new ResultSetTable(evt.getDbUtils().getDatabaseURL(), evt.getDbUtils().getUsername(), evt.getDbUtils().getPassword(), evt.getQuery(), new ResultSetTableModel(evt.getResultSet(), evt.getMaxRows()));
            this.m_TabbedPane.addTab(this.getNextTabName(), new JScrollPane(table));
            this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setButtons();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setButtons();
        if (this.getCurrentTable() != null) {
            this.notifyListeners(this.getCurrentTable().getURL(), this.getCurrentTable().getUser(), this.getCurrentTable().getPassword(), this.getCurrentTable().getQuery());
        }
    }

    public QueryPanel getQueryPanel() {
        return this.m_QueryPanel;
    }

    public void setQueryPanel(QueryPanel panel) {
        this.m_QueryPanel = panel;
    }

    protected ResultSetTable getCurrentTable() {
        ResultSetTable table = null;
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1) {
            JScrollPane pane = (JScrollPane)this.m_TabbedPane.getComponentAt(index);
            JViewport port = (JViewport)pane.getComponent(0);
            table = (ResultSetTable)port.getComponent(0);
        }
        return table;
    }

    protected void close() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index > -1) {
            try {
                this.getCurrentTable().finalize();
            }
            catch (Throwable t) {
                System.out.println(t);
            }
            this.m_TabbedPane.removeTabAt(index);
        }
        this.setButtons();
    }

    protected void closeAll() {
        while (this.m_TabbedPane.getTabCount() > 0) {
            this.m_TabbedPane.setSelectedIndex(0);
            try {
                this.getCurrentTable().finalize();
            }
            catch (Throwable t) {
                System.out.println(t);
            }
            this.m_TabbedPane.removeTabAt(0);
        }
        this.setButtons();
    }

    protected void copyQuery() {
        if (this.getCurrentTable() != null && this.getQueryPanel() != null) {
            this.getQueryPanel().setQuery(this.getCurrentTable().getQuery());
        }
    }

    protected void calcOptimalWidth() {
        if (this.getCurrentTable() != null) {
            JTableHelper.setOptimalColumnWidth(this.getCurrentTable());
        }
    }

    public void addResultChangedListener(ResultChangedListener l) {
        this.m_Listeners.add(l);
    }

    public void removeResultChangedListener(ResultChangedListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifyListeners(String url, String user, String pw, String query) {
        for (ResultChangedListener l : this.m_Listeners) {
            l.resultChanged(new ResultChangedEvent(this, url, user, pw, query));
        }
    }
}

