/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GraftSplit
extends ClassifierSplitModel
implements Comparable {
    private static final long serialVersionUID = 722773260393182051L;
    private Distribution m_graftdistro;
    private int m_attIndex;
    private double m_splitPoint;
    private int m_maxClass;
    private int m_otherLeafMaxClass;
    private double m_laplace;
    private Distribution m_leafdistro;
    private int m_testType;

    public GraftSplit(int a, double v, int t, double c, double l) {
        this.m_attIndex = a;
        this.m_splitPoint = v;
        this.m_testType = t;
        this.m_maxClass = (int)c;
        this.m_laplace = l;
    }

    public GraftSplit(int a, double v, int t, double oC, double[][] counts) throws Exception {
        this.m_attIndex = a;
        this.m_splitPoint = v;
        this.m_testType = t;
        this.m_otherLeafMaxClass = (int)oC;
        this.m_numSubsets = 2;
        int subset = this.subsetOfInterest();
        this.m_distribution = new Distribution(counts);
        double[][] lcounts = new double[1][this.m_distribution.numClasses()];
        for (int c = 0; c < lcounts[0].length; ++c) {
            lcounts[0][c] = counts[subset][c];
        }
        this.m_leafdistro = new Distribution(lcounts);
        this.m_maxClass = this.m_distribution.maxClass(subset);
        this.m_laplace = (this.m_distribution.perClassPerBag(subset, this.m_maxClass) + 1.0) / (this.m_distribution.perBag(subset) + 2.0);
    }

    public void deleteGraftedCases(Instances data) {
        int subOfInterest = this.subsetOfInterest();
        for (int x = 0; x < data.numInstances(); ++x) {
            if (this.whichSubset(data.instance(x)) != subOfInterest) continue;
            data.delete(x--);
        }
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        double factor;
        this.m_graftdistro = new Distribution(2, data.numClasses());
        int subset = this.subsetOfInterest();
        double thisNodeCount = 0.0;
        double knownCases = 0.0;
        boolean allKnown = true;
        for (int x = 0; x < data.numInstances(); ++x) {
            Instance instance = data.instance(x);
            if (instance.isMissing(this.m_attIndex)) {
                allKnown = false;
                continue;
            }
            knownCases += instance.weight();
            int subst = this.whichSubset(instance);
            if (subst == -1) continue;
            this.m_graftdistro.add(subst, instance);
            if (subst != subset) continue;
            thisNodeCount += instance.weight();
        }
        double d = factor = knownCases == 0.0 ? 0.5 : thisNodeCount / knownCases;
        if (!allKnown) {
            for (int x = 0; x < data.numInstances(); ++x) {
                Instance instance;
                int subst;
                if (!data.instance(x).isMissing(this.m_attIndex) || (subst = this.whichSubset(instance = data.instance(x))) == -1) continue;
                instance.setWeight(instance.weight() * factor);
                this.m_graftdistro.add(subst, instance);
            }
        }
        if (this.m_graftdistro.perBag(subset) == 0.0) {
            double[] counts = new double[data.numClasses()];
            counts[this.m_maxClass] = 0.01;
            this.m_graftdistro.add(subset, counts);
        }
        if (this.m_graftdistro.perBag(subset == 0 ? 1 : 0) == 0.0) {
            double[] counts = new double[data.numClasses()];
            counts[this.m_otherLeafMaxClass] = 0.01;
            this.m_graftdistro.add(subset == 0 ? 1 : 0, counts);
        }
    }

    public NoSplit getLeaf() {
        return new NoSplit(this.m_leafdistro);
    }

    public NoSplit getOtherLeaf() {
        int bag = this.subsetOfInterest() == 0 ? 1 : 0;
        double[][] counts = new double[1][this.m_graftdistro.numClasses()];
        double totals = 0.0;
        for (int c = 0; c < counts[0].length; ++c) {
            counts[0][c] = this.m_graftdistro.perClassPerBag(bag, c);
            totals += counts[0][c];
        }
        if (totals == 0.0) {
            double[] dArray = counts[0];
            int n = this.m_otherLeafMaxClass;
            dArray[n] = dArray[n] + 0.01;
        }
        return new NoSplit(new Distribution(counts));
    }

    public final String dumpLabelG(int index, Instances data) throws Exception {
        StringBuffer text = new StringBuffer();
        text.append(data.classAttribute().value(index == this.subsetOfInterest() ? this.m_maxClass : this.m_otherLeafMaxClass));
        text.append(" (" + Utils.roundDouble(this.m_graftdistro.perBag(index), 1));
        if (Utils.gr(this.m_graftdistro.numIncorrect(index), 0.0)) {
            text.append("/" + Utils.roundDouble(this.m_graftdistro.numIncorrect(index), 2));
        }
        if (index == this.subsetOfInterest()) {
            text.append("|" + Utils.roundDouble(this.m_distribution.perBag(index), 2));
            if (Utils.gr(this.m_distribution.numIncorrect(index), 0.0)) {
                text.append("/" + Utils.roundDouble(this.m_distribution.numIncorrect(index), 2));
            }
        }
        text.append(")");
        return text.toString();
    }

    public int subsetOfInterest() {
        if (this.m_testType == 2) {
            return 0;
        }
        if (this.m_testType == 3) {
            return 1;
        }
        return this.m_testType;
    }

    public double positivesForSubsetOfInterest() {
        return this.m_distribution.perClassPerBag(this.subsetOfInterest(), this.m_maxClass);
    }

    public double positives(int subset) {
        return this.m_distribution.perClassPerBag(subset, this.m_distribution.maxClass(subset));
    }

    public double totalForSubsetOfInterest() {
        return this.m_distribution.perBag(this.subsetOfInterest());
    }

    public double totalForSubset(int subset) {
        return this.m_distribution.perBag(subset);
    }

    @Override
    public String leftSide(Instances data) {
        return data.attribute(this.m_attIndex).name();
    }

    public int attribute() {
        return this.m_attIndex;
    }

    @Override
    public final String rightSide(int index, Instances data) {
        StringBuffer text = new StringBuffer();
        if (data.attribute(this.m_attIndex).isNominal()) {
            if (index == 0) {
                text.append(" = " + data.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            } else {
                text.append(" != " + data.attribute(this.m_attIndex).value((int)this.m_splitPoint));
            }
        } else if (index == 0) {
            text.append(" <= " + Utils.doubleToString(this.m_splitPoint, 6));
        } else {
            text.append(" > " + Utils.doubleToString(this.m_splitPoint, 6));
        }
        return text.toString();
    }

    @Override
    public final String sourceExpression(int index, Instances data) {
        StringBuffer expr = null;
        if (index < 0) {
            return "i[" + this.m_attIndex + "] == null";
        }
        if (data.attribute(this.m_attIndex).isNominal()) {
            expr = index == 0 ? new StringBuffer("i[") : new StringBuffer("!i[");
            expr.append(this.m_attIndex).append("]");
            expr.append(".equals(\"").append(data.attribute(this.m_attIndex).value((int)this.m_splitPoint)).append("\")");
        } else {
            expr = new StringBuffer("((Double) i[");
            expr.append(this.m_attIndex).append("])");
            if (index == 0) {
                expr.append(".doubleValue() <= ").append(this.m_splitPoint);
            } else {
                expr.append(".doubleValue() > ").append(this.m_splitPoint);
            }
        }
        return expr.toString();
    }

    @Override
    public double[] weights(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            double[] weights = new double[this.m_numSubsets];
            for (int i = 0; i < this.m_numSubsets; ++i) {
                weights[i] = this.m_graftdistro.perBag(i) / this.m_graftdistro.total();
            }
            return weights;
        }
        return null;
    }

    @Override
    public int whichSubset(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            return -1;
        }
        if (instance.attribute(this.m_attIndex).isNominal()) {
            if (instance.value(this.m_attIndex) == this.m_splitPoint) {
                return 0;
            }
            return 1;
        }
        if (Utils.smOrEq(instance.value(this.m_attIndex), this.m_splitPoint)) {
            return 0;
        }
        return 1;
    }

    public double splitPoint() {
        return this.m_splitPoint;
    }

    public int maxClassForSubsetOfInterest() {
        return this.m_maxClass;
    }

    public double laplaceForSubsetOfInterest() {
        return this.m_laplace;
    }

    public int testType() {
        return this.m_testType;
    }

    public int compareTo(Object g) {
        if (this.m_laplace > ((GraftSplit)g).laplaceForSubsetOfInterest()) {
            return 1;
        }
        if (this.m_laplace < ((GraftSplit)g).laplaceForSubsetOfInterest()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset <= -1) {
            double[] weights = this.weights(instance);
            if (weights == null) {
                return this.m_distribution.prob(classIndex);
            }
            double prob = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                prob += weights[i] * this.m_distribution.prob(classIndex, i);
            }
            return prob;
        }
        if (Utils.gr(this.m_distribution.perBag(theSubset), 0.0)) {
            return this.m_distribution.prob(classIndex, theSubset);
        }
        return this.m_distribution.prob(classIndex);
    }

    public String toString(Instances data) {
        String theTest = this.m_testType == 0 ? " <= " : (this.m_testType == 1 ? " > " : (this.m_testType == 2 ? " = " : " != "));
        theTest = data.attribute(this.m_attIndex).isNominal() ? theTest + data.attribute(this.m_attIndex).value((int)this.m_splitPoint) : theTest + Double.toString(this.m_splitPoint);
        return data.attribute(this.m_attIndex).name() + theTest + " (" + Double.toString(this.m_laplace) + ") --> " + data.attribute(data.classIndex()).value(this.m_maxClass);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

