/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.experiment.Stats;

public class PairedStats
implements RevisionHandler {
    public Stats xStats = new Stats();
    public Stats yStats = new Stats();
    public Stats differencesStats = new Stats();
    public double differencesProbability;
    public double correlation;
    public double xySum;
    public double count;
    public int differencesSignificance;
    public double sigLevel;
    protected int m_degreesOfFreedom = 0;

    public PairedStats(double sig) {
        this.sigLevel = sig;
    }

    public void setDegreesOfFreedom(int d) {
        if (d <= 0) {
            throw new IllegalArgumentException("PairedStats: degrees of freedom must be >= 1");
        }
        this.m_degreesOfFreedom = d;
    }

    public int getDegreesOfFreedom() {
        return this.m_degreesOfFreedom;
    }

    public void add(double value1, double value2) {
        this.xStats.add(value1);
        this.yStats.add(value2);
        this.differencesStats.add(value1 - value2);
        this.xySum += value1 * value2;
        this.count += 1.0;
    }

    public void subtract(double value1, double value2) {
        this.xStats.subtract(value1);
        this.yStats.subtract(value2);
        this.differencesStats.subtract(value1 - value2);
        this.xySum -= value1 * value2;
        this.count -= 1.0;
    }

    public void add(double[] value1, double[] value2) {
        if (value1 == null || value2 == null) {
            throw new NullPointerException();
        }
        if (value1.length != value2.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
        for (int i = 0; i < value1.length; ++i) {
            this.add(value1[i], value2[i]);
        }
    }

    public void subtract(double[] value1, double[] value2) {
        if (value1 == null || value2 == null) {
            throw new NullPointerException();
        }
        if (value1.length != value2.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
        for (int i = 0; i < value1.length; ++i) {
            this.subtract(value1[i], value2[i]);
        }
    }

    public void calculateDerived() {
        this.xStats.calculateDerived();
        this.yStats.calculateDerived();
        this.differencesStats.calculateDerived();
        this.correlation = Double.NaN;
        if (!(Double.isNaN(this.xStats.stdDev) || Double.isNaN(this.yStats.stdDev) || Utils.eq(this.xStats.stdDev, 0.0))) {
            double slope = (this.xySum - this.xStats.sum * this.yStats.sum / this.count) / (this.xStats.sumSq - this.xStats.sum * this.xStats.mean);
            this.correlation = !Utils.eq(this.yStats.stdDev, 0.0) ? slope * this.xStats.stdDev / this.yStats.stdDev : 1.0;
        }
        if (Utils.gr(this.differencesStats.stdDev, 0.0)) {
            double tval = this.differencesStats.mean * Math.sqrt(this.count) / this.differencesStats.stdDev;
            this.differencesProbability = this.m_degreesOfFreedom >= 1 ? Statistics.FProbability(tval * tval, 1, this.m_degreesOfFreedom) : (this.count > 1.0 ? Statistics.FProbability(tval * tval, 1, (int)this.count - 1) : 1.0);
        } else {
            this.differencesProbability = this.differencesStats.sumSq == 0.0 ? 1.0 : 0.0;
        }
        this.differencesSignificance = 0;
        if (this.differencesProbability <= this.sigLevel) {
            this.differencesSignificance = this.xStats.mean > this.yStats.mean ? 1 : -1;
        }
    }

    public String toString() {
        return "Analysis for " + Utils.doubleToString(this.count, 0) + " points:\n" + "                " + "         Column 1" + "         Column 2" + "       Difference\n" + "Minimums        " + Utils.doubleToString(this.xStats.min, 17, 4) + Utils.doubleToString(this.yStats.min, 17, 4) + Utils.doubleToString(this.differencesStats.min, 17, 4) + '\n' + "Maximums        " + Utils.doubleToString(this.xStats.max, 17, 4) + Utils.doubleToString(this.yStats.max, 17, 4) + Utils.doubleToString(this.differencesStats.max, 17, 4) + '\n' + "Sums            " + Utils.doubleToString(this.xStats.sum, 17, 4) + Utils.doubleToString(this.yStats.sum, 17, 4) + Utils.doubleToString(this.differencesStats.sum, 17, 4) + '\n' + "SumSquares      " + Utils.doubleToString(this.xStats.sumSq, 17, 4) + Utils.doubleToString(this.yStats.sumSq, 17, 4) + Utils.doubleToString(this.differencesStats.sumSq, 17, 4) + '\n' + "Means           " + Utils.doubleToString(this.xStats.mean, 17, 4) + Utils.doubleToString(this.yStats.mean, 17, 4) + Utils.doubleToString(this.differencesStats.mean, 17, 4) + '\n' + "SDs             " + Utils.doubleToString(this.xStats.stdDev, 17, 4) + Utils.doubleToString(this.yStats.stdDev, 17, 4) + Utils.doubleToString(this.differencesStats.stdDev, 17, 4) + '\n' + "Prob(differences) " + Utils.doubleToString(this.differencesProbability, 4) + " (sigflag " + this.differencesSignificance + ")\n" + "Correlation       " + Utils.doubleToString(this.correlation, 4) + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        try {
            String line;
            PairedStats ps = new PairedStats(0.05);
            LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("@") || line.startsWith("%")) continue;
                StringTokenizer s = new StringTokenizer(line, " ,\t\n\r\f");
                int count = 0;
                double v1 = 0.0;
                double v2 = 0.0;
                while (s.hasMoreTokens()) {
                    double val = new Double(s.nextToken());
                    if (count == 0) {
                        v1 = val;
                    } else if (count == 1) {
                        v2 = val;
                    } else {
                        System.err.println("MSG: Too many values in line \"" + line + "\", skipped.");
                        break;
                    }
                    ++count;
                }
                if (count != 2) continue;
                ps.add(v1, v2);
            }
            ps.calculateDerived();
            System.err.println(ps);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

