/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class CrossValidationFoldMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -6350179298851891512L;
    private int m_numFolds = 10;
    private int m_randomSeed = 1;
    private boolean m_preserveOrder = false;
    private transient Thread m_foldThread = null;

    public CrossValidationFoldMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/CrossValidationFoldMaker.gif", "weka/gui/beans/icons/CrossValidationFoldMaker_animated.gif");
        this.m_visual.setText("CrossValidationFoldMaker");
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Split an incoming data set into cross validation folds. Separate train and test sets are produced for each of the k folds.";
    }

    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    public void acceptDataSet(DataSetEvent e) {
        if (e.isStructureOnly()) {
            TrainingSetEvent tse = new TrainingSetEvent(this, e.getDataSet());
            TestSetEvent tsee = new TestSetEvent(this, e.getDataSet());
            this.notifyTrainingSetProduced(tse);
            this.notifyTestSetProduced(tsee);
            return;
        }
        if (this.m_foldThread == null) {
            final Instances dataSet = new Instances(e.getDataSet());
            this.m_foldThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    boolean errorOccurred = false;
                    try {
                        try {
                            Random random = new Random(CrossValidationFoldMaker.this.getSeed());
                            if (!CrossValidationFoldMaker.this.m_preserveOrder) {
                                dataSet.randomize(random);
                            }
                            if (dataSet.classIndex() >= 0 && dataSet.attribute(dataSet.classIndex()).isNominal() && !CrossValidationFoldMaker.this.m_preserveOrder) {
                                dataSet.stratify(CrossValidationFoldMaker.this.getFolds());
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] " + "stratifying data");
                                }
                            }
                            for (int i = 0; i < CrossValidationFoldMaker.this.getFolds(); ++i) {
                                if (CrossValidationFoldMaker.this.m_foldThread == null) {
                                    if (CrossValidationFoldMaker.this.m_logger == null) break;
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation has been canceled!");
                                    break;
                                }
                                Instances train = !CrossValidationFoldMaker.this.m_preserveOrder ? dataSet.trainCV(CrossValidationFoldMaker.this.getFolds(), i, random) : dataSet.trainCV(CrossValidationFoldMaker.this.getFolds(), i);
                                Instances test = dataSet.testCV(CrossValidationFoldMaker.this.getFolds(), i);
                                TrainingSetEvent tse = new TrainingSetEvent(this, train);
                                tse.m_setNumber = i + 1;
                                tse.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                String msg = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(msg + "seed: " + CrossValidationFoldMaker.this.getSeed() + " folds: " + CrossValidationFoldMaker.this.getFolds() + "|Training fold " + (i + 1));
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread != null) {
                                    CrossValidationFoldMaker.this.notifyTrainingSetProduced(tse);
                                }
                                TestSetEvent teste = new TestSetEvent(this, test);
                                teste.m_setNumber = i + 1;
                                teste.m_maxSetNumber = CrossValidationFoldMaker.this.getFolds();
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(msg + "seed: " + CrossValidationFoldMaker.this.getSeed() + " folds: " + CrossValidationFoldMaker.this.getFolds() + "|Test fold " + (i + 1));
                                }
                                if (CrossValidationFoldMaker.this.m_foldThread == null) continue;
                                CrossValidationFoldMaker.this.notifyTestSetProduced(teste);
                            }
                            Object var10_10 = null;
                        }
                        catch (Exception ex) {
                            errorOccurred = true;
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] problem during fold creation. " + ex.getMessage());
                            }
                            ex.printStackTrace();
                            CrossValidationFoldMaker.this.stop();
                            Object var10_11 = null;
                            CrossValidationFoldMaker.this.m_foldThread = null;
                            if (errorOccurred) {
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "ERROR (See log for details).");
                                }
                            } else if (this.isInterrupted()) {
                                String msg = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                                } else {
                                    System.err.println(msg);
                                }
                            } else {
                                String msg = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                                if (CrossValidationFoldMaker.this.m_logger != null) {
                                    CrossValidationFoldMaker.this.m_logger.statusMessage(msg + "Finished.");
                                }
                            }
                            CrossValidationFoldMaker.this.block(false);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        CrossValidationFoldMaker.this.m_foldThread = null;
                        if (errorOccurred) {
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "ERROR (See log for details).");
                            }
                        } else if (this.isInterrupted()) {
                            String msg = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                                CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                            } else {
                                System.err.println(msg);
                            }
                        } else {
                            String msg = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                            if (CrossValidationFoldMaker.this.m_logger != null) {
                                CrossValidationFoldMaker.this.m_logger.statusMessage(msg + "Finished.");
                            }
                        }
                        CrossValidationFoldMaker.this.block(false);
                        throw throwable;
                    }
                    CrossValidationFoldMaker.this.m_foldThread = null;
                    if (errorOccurred) {
                        if (CrossValidationFoldMaker.this.m_logger != null) {
                            CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "ERROR (See log for details).");
                        }
                    } else if (this.isInterrupted()) {
                        String msg = "[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted";
                        if (CrossValidationFoldMaker.this.m_logger != null) {
                            CrossValidationFoldMaker.this.m_logger.logMessage("[" + CrossValidationFoldMaker.this.getCustomName() + "] Cross validation interrupted");
                            CrossValidationFoldMaker.this.m_logger.statusMessage(CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|" + "INTERRUPTED");
                        } else {
                            System.err.println(msg);
                        }
                    } else {
                        String msg = CrossValidationFoldMaker.this.getCustomName() + "$" + CrossValidationFoldMaker.this.hashCode() + "|";
                        if (CrossValidationFoldMaker.this.m_logger != null) {
                            CrossValidationFoldMaker.this.m_logger.statusMessage(msg + "Finished.");
                        }
                    }
                    CrossValidationFoldMaker.this.block(false);
                }
            };
            this.m_foldThread.setPriority(1);
            this.m_foldThread.start();
            this.block(true);
            this.m_foldThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTestSetProduced(TestSetEvent tse) {
        Vector l;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            l = (Vector)this.m_testListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size() && this.m_foldThread != null; ++i) {
                ((TestSetListener)l.elementAt(i)).acceptTestSet(tse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent tse) {
        Vector l;
        CrossValidationFoldMaker crossValidationFoldMaker = this;
        synchronized (crossValidationFoldMaker) {
            l = (Vector)this.m_trainingListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size() && this.m_foldThread != null; ++i) {
                ((TrainingSetListener)l.elementAt(i)).acceptTrainingSet(tse);
            }
        }
    }

    public void setFolds(int numFolds) {
        this.m_numFolds = numFolds;
    }

    public int getFolds() {
        return this.m_numFolds;
    }

    public String foldsTipText() {
        return "The number of train and test splits to produce";
    }

    public void setSeed(int randomSeed) {
        this.m_randomSeed = randomSeed;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String seedTipText() {
        return "The randomization seed";
    }

    public boolean getPreserveOrder() {
        return this.m_preserveOrder;
    }

    public void setPreserveOrder(boolean p) {
        this.m_preserveOrder = p;
    }

    public boolean isBusy() {
        return this.m_foldThread != null;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_foldThread != null) {
            Thread temp = this.m_foldThread;
            this.m_foldThread = null;
            temp.interrupt();
            temp.stop();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_foldThread != null && this.m_foldThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_foldThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (CrossValidation)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }
}

