% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_characters.R
\name{rx_space}
\alias{rx_space}
\title{Match a space character.}
\usage{
rx_space(.data = NULL, inverse = FALSE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{inverse}{Invert match behavior, defaults to \code{FALSE} (match
space). Use \code{TRUE} to \emph{not} match space.}
}
\description{
Matches a space character.
}
\examples{
# match space, default
rx_space()

# dont match space
rx_space(inverse = TRUE)

# create an expression
x <- rx_space()

# create input
string <- "1 apple\\t"

# extract match
regmatches(string, regexpr(x, string))

# extract no whitespace by inverting behavior
y <- rx_space(inverse = TRUE)
regmatches(string, gregexpr(y, string))
}
