\name{create_analytics}
\alias{create_analytics}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates an object of class analytics given classification results.
}
\description{
Takes the results from functions \code{\link{classify_model}} or \code{\link{classify_models}} and computes various statistics to help interpret the data.
}
\usage{
create_analytics(container, classification_results, b=1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{container}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_container}} function.
}
  \item{classification_results}{
A \code{cbind()} of result objects returned by \code{\link{classify_model}}, or the object returned by \code{\link{classify_models}}.
}
  \item{b}{
b-value for generating precision, recall, and F-scores statistics.
}
}
\value{
Object of class \code{\link{analytics_virgin-class}} or \code{\link{analytics-class}} has either two or four slots respectively, depending on whether the \code{virgin} flag is set to \code{TRUE} or \code{FALSE} in \code{\link{create_container}}. They can be accessed using the \code{@} operator 
for S4 classes (e.g. \code{analytics@document_summary}).
}
\author{
Timothy P. Jurka <tpjurka@ucdavis.edu>, Loren Collingwood <lorenc2@uw.edu>
}
\examples{
library(RTextTools)
data(NYTimes)
data <- NYTimes[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data["Title"],data["Subject"]), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=tm::weightTfIdf)
container <- create_container(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(container, algorithms=c("MAXENT","SVM"))
results <- classify_models(container, models)
analytics <- create_analytics(container, results)
}
\keyword{method}
