\name{create_scoreSummary}
\alias{create_scoreSummary}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
creates a summary with the best label for each document.
}
\description{
Creates a summary with the best label for each document, determined by highest algorithm certainty, and highest consensus (i.e. most number of algorithms agreed).
}
\usage{
create_scoreSummary(corpus, classification_results)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_corpus}} function.
}
  \item{classification_results}{
A \code{cbind()} of result objects returned by \code{\link{classify_model}}, or the object returned by \code{\link{classify_models}}.
}
}
\author{
Timothy P. Jurka <tpjurka@ucdavis.edu>, Loren Collingwood <lorenc2@uw.edu>
}
\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
models <- train_models(corpus, algorithms=c("MAXENT","SVM"))
results <- classify_models(corpus, models)
score_summary <- create_scoreSummary(corpus, results)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{method}
