% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{data}
\name{mapCH2016}
\alias{mapCH2016}
\title{Geodata of Swiss municipalities, districts, cantons and lakes (2016)}
\format{A data frame with 162,148 rows and 10 variables:
\describe{
  \item{year}{year of geodata}
  \item{endofyear}{if \code{0}, the data dates from \code{year}-1-1, else from \code{year}-31-12}
  \item{long}{longitude of point}
  \item{lat}{latitude of point}
  \item{group}{if two adjacent points are in the same group, then they get connected}
  \item{type}{type of object point belongs to: municipality, district, canton, country, lake)}
  \item{id}{official identification number of object}
  \item{name}{name of object}
  \item{dis}{district object belongs to}
  \item{can}{canton object belongs to}}}
\source{
Swiss Federal Statistical Office, GEOSTAT (last download 2017-09-07)
}
\usage{
mapCH2016
}
\description{
A ggplot2-compatible data frame containing geodata of Swiss municipalities, districts,
 cantons and lakes for 2016.  The data is made publicly available by the Swiss
 Federal Statistical Office.  The administrative divisions are scaled at 1:2,000,000.
}
\references{
\url{https://www.bfs.admin.ch/bfs/de/home/dienstleistungen/geostat/geodaten-bundesstatistik/administrative-grenzen/generalisierte-gemeindegrenzen.html}
}
\author{
David Zumbach \email{david.zumbach@gfzb.ch}
}
\keyword{datasets}
