% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{pfree.equ}
\alias{pfree.equ}
\title{Equilibrium probability of freedom}
\usage{
pfree.equ(sep, p.intro)
}
\arguments{
\item{sep}{population sensitivity for time period (scalar or
vector)}

\item{p.intro}{probability of introduction for time period (scalar
or vector of same length as sep)}
}
\value{
a list of 2 vectors, equilibrium posterior probability of freedom
  and equilibrium prior (discounted) probability of freedom
}
\description{
Calculates equilibrium probability of disease freedom and
  equilibrium prior probability of freedom, after discounting for
  probability of introduction
}
\examples{
# examples of pfree.equ
pfree.equ(runif(10, 0.4, 0.6), 0.01)
pfree.equ(0.8, 0.05)
pfree.equ(rep(0.9, 6), c(0.0001, 0.0005, 0.001, 0.005, 0.01, 0.05))
}
\keyword{methods}

