% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{stripe_update_card}
\alias{stripe_update_card}
\title{Update a credit card on Stripe.}
\usage{
stripe_update_card(api_key, customer_id, card_id, args)
}
\arguments{
\item{api_key}{Your Stripe API Key}

\item{customer_id}{The id for the customer you want the credit card
added to.}

\item{card_id}{The id for the card you want to update}

\item{args}{A list that can contain the following
\describe{
   \item{address_city}{\emph{optional}}
   \item{address_country}{\emph{optional}}
   \item{address_line1}{\emph{optional}}
   \item{address_line2}{\emph{optional}}
   \item{address_state}{\emph{optional}}
   \item{address_zip}{\emph{optional}}
   \item{exp_month}{\emph{optional}}
   \item{exp_year}{\emph{optional}}
   \item{name}{\emph{optional}}
}}
}
\value{
A data frame with card information
}
\description{
Update infomration about the billing address for a credit card as well as other fields.
}
\examples{
\dontrun{stripe_update_card("sk_test_BQokikJOvBiI2HlWgH4olfQ2", "cus_4cb7HNjNSqqV2H",
"card_14TLyd2eZvKYloc2C9PXnfFmi", list(exp_year="04"))}

}

