% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterEntropy.R
\name{rasterEntropy}
\alias{rasterEntropy}
\title{Multi-layer Pixel Entropy}
\usage{
rasterEntropy(img, ...)
}
\arguments{
\item{img}{RasterStack or RasterBrick}

\item{...}{additional arguments passed to writeRaster}
}
\value{
RasterLayer "entropy"
}
\description{
Shannon entropy is calculated for each pixel based on it's layer values.
To be used with categorical / integer valued rasters.
}
\details{
Entropy is calculated as -sum(p log(p)); p being the class frequency per pixel.
}
\examples{
data(rlogo)
re <- rasterEntropy(rlogo)
ggR(re, geom_raster = TRUE)
}

