% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.smet.R
\name{collapse.smet}
\alias{collapse.smet}
\title{Coerces a \code{smet-class} object to a data frame}
\usage{
collapse.smet(x, y, headers = NULL, date.field = "timestamp")
}
\arguments{
\item{x}{first \code{\link{smet-class}} object}

\item{y}{second \code{\link{smet-class}} object}

\item{headers}{header attributes to  check before collapsing}

\item{date.field}{field name used for date and time. Default is \code{"timestamp"}, as used for \code{SMET} format.}
}
\value{
a collapsed \code{\link{smet-class}} object
}
\description{
Coerces a \code{smet-class} object to a data frame
}
\examples{

smet1 <- as.smet(system.file("examples/zugspitze1.smet",package="RSMET"))
smet2 <- as.smet(system.file("examples/zugspitze2.smet",package="RSMET"))

newsmet <- collapse.smet(x=smet1,y=smet2)

newsmet_ <- collapse.smet(x=smet2,y=smet1)


x <- smet(system.file('examples/PIEM001114.smet',package="RSMET"))
y <- smet(system.file('examples/PIEM001114_20160308.smet',package="RSMET"))


xy <-  collapse.smet(x,y) 

}

