% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.smet.R
\docType{methods}
\name{as.smet}
\alias{as.smet}
\alias{as.smet,character-method}
\alias{as.smet,data.frame-method}
\alias{as.smet,list-method}
\alias{as.smet,smet-method}
\title{Coerces an object to a \code{smet-class}  object}
\usage{
as.smet(object, ...)

as.smet(object, ...)

\S4method{as.smet}{character}(object, ...)

\S4method{as.smet}{data.frame}(object, mult = NA, offset = NA,
  date.field = "timestamp", station.field = "station_id",
  header.fields = c("longitude", "latitude", "station_id", "altitude",
  "location"), variables = NULL, force.multistation = FALSE,
  metaparam = attr(object, "metaparam"), file = NA, ...)

\S4method{as.smet}{list}(object, ...)

\S4method{as.smet}{smet}(object, ...)
}
\arguments{
\item{object}{the object to be coerced}

\item{...}{further arguments}

\item{mult, offset}{numeric vectors of unit multiplier and offset respectivaly}

\item{date.field}{field name used for date and time. Default is \code{"timestamp"}, as used for \code{SMET} format.}

\item{station.field}{field name used for station ID. Default is \code{"station_id"}, as used for \code{SMET} format.}

\item{header.fields}{names used for the SMET header. Defaults are \code{c("longitude","latitude","station_id" ,"altitude","location")}}

\item{variables}{(optional) selection of variables hich can be exported to SMET formats. It is used only in case of two or more stations.}

\item{force.multistation}{logical value. If it is \code{TRUE} the method is forced to return a list of SMET objects even in case of only one station}

\item{metaparam}{metedata optional data frame containig meta info on variables. It can be entered as an attribute of \code{object}. See the structure of \code{metaparam} of \code{\link{meteofrance}}.It must contains \code{SMET_ID},\code{SMET_UNIT_MULTIPLIER},\code{SMET_UNIT_OFFSET} columns/fields.}

\item{file}{full filename of the reference SMET filename (not considered when \code{object} is \code{character} .}
}
\description{
The method \code{as.smet} coerces an object or a charachter string to a SMET. If the object is

as.smet

as.smet

as.smet

as.smet

as.smet
}
\examples{
data(meteofrance)


## Choose a particular station 
station_id <-  unique(meteofrance$station_id)[3]




variables <- c("timestamp","DW","VW","TA","TD","RH","MFR_rr24",
      "MFR_tn12","MFR_tn24","MFR_tx12","MFR_tx24","HS","HS_fresh")
header <- c("longitude","latitude","station_id" ,"altitude","location")
names(header) <- header



data <- meteofrance[meteofrance$station_id==station_id,c(header,variables)]
metaparam <- attr(meteofrance,"metaparam")
metaparam <- metaparam[metaparam$SMET_ID \%in\% names(data),]
header <- lapply(X=header,FUN=function(x,data) {data[1,x]},data=data)
data <- data[,variables]
attr(data,"header") <- header
attr(data,"metaparam") <- metaparam

sm <- as.smet(data)

# In case of multiple station, it return a list of SMET-class objects: 

sm_multi <- as.smet(meteofrance,variables=variables)


  


}

