% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{RQ_ddCt}
\alias{RQ_ddCt}
\title{RQ_ddCt}
\usage{
RQ_ddCt(
  data,
  group.study,
  group.ref,
  do.tests = TRUE,
  pairwise = FALSE,
  alternative = "two.sided",
  p.adjust.method = "BH",
  save.to.txt = FALSE,
  name.txt = "ddCt_RQ_results"
)
}
\arguments{
\item{data}{Data object returned from delta_Ct() function.}

\item{group.study}{Character: name of study group (group of interest).}

\item{group.ref}{Character: name of reference group.}

\item{do.tests}{Logical: if TRUE, statistical significance of delta delta Ct values between compared groups
is calculated using Student's t test and Mann-Whitney U test. Default to TRUE.}

\item{pairwise}{Logical: set to TRUE if a pairwise analysis should be done.}

\item{alternative}{Character: alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{p.adjust.method}{Character: p value correction method for multiple testing, one of the "holm", "hochberg", "hommel",
"bonferroni", "BH" (default), "BY","fdr", or "none". See documentation for stats::p.adjust() function for details.}

\item{save.to.txt}{Logical: if TRUE, returned table with results is saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "results_ddCt".}
}
\value{
Data frame with relative quantification results.
}
\description{
This function performs relative quantification of gene expression using 2^-ddCt method.
}
\details{
This function performs:
1. Calculation of means (returned in columns with the "_mean" pattern) and standard deviations (returned
in columns with the "_sd" pattern) of delta Ct values for analyzed genes across compared groups.
2. Normality tests (Shapiro_Wilk test) of delta Ct values of analyzed genes across compared groups and returned p values are
stored in columns with the "_norm_p" pattern.
3. Calculation of differences in mean delta Ct values of genes between compared groups, obtaining delta delta Ct values (returned  in"ddCt" column).
4. Calculation of fold change values (returned in "FCh" column) for each gene by exponentiation of ddCt values using 2^-ddCt formula.
5. Statistical testing of differences between study group and reference group using Student's t test and Mann-Whitney U test.
Resulted statistics (in column with "_test_stat" pattern) and p values (in column with "_test_p" pattern) are returned.
6. P values adjusted for multiple testing using a selected method.
}
\examples{
library(tidyverse)
library(coin)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("FGF23","ANGPT2","IL1A","CSF2","IL6"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "GAPDH")
results.ddCt <- RQ_ddCt(data.dCt, "AAA", "Control")
head(results.ddCt)

}
