% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{make_Ct_ready}
\alias{make_Ct_ready}
\title{make_Ct_ready}
\usage{
make_Ct_ready(
  data,
  imput.by.mean.within.groups,
  save.to.txt = FALSE,
  name.txt = "Ct_ready"
)
}
\arguments{
\item{data}{Data object returned from read_Ct_long(), read_Ct_wide() or filter_Ct() function,
or data frame containing column named "Sample" with sample names, column named "Gene" with gene names,
column named "Ct" with raw Ct values (must be numeric), column named "Group" with group names. Presence of any other columns is allowed,
but they will not be used by this function.}

\item{imput.by.mean.within.groups}{Logical: if TRUE, missing values will be imputed by means calculated separately for each group.
This parameter can influence results, thus to draw more user attention on this parameter, no default value was set.}

\item{save.to.txt}{Logical: if TRUE, returned data will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "Ct_ready".}
}
\value{
Data frame with prepared data. Information about number and percentage of missing values is also printed.
}
\description{
This function collapses technical replicates (if present in data) by means and (optionally) imputes missing data by means calculated separately for each group.
This function also prepares Ct data for further steps of analysis.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
head(data.CtF.ready)

}
