% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plot_loadings}
\alias{plot_loadings}
\title{Plot loadings of a principal component}
\usage{
plot_loadings(
  pca_res,
  PC = 1,
  color_by = NULL,
  annotate_top_n = 0,
  highlight_genes = NULL,
  show_plot = TRUE
)
}
\arguments{
\item{pca_res}{A result returned from \code{plot_pca()}}

\item{PC}{Number of the principal component to plot}

\item{color_by}{Variable (column in \code{pca_res$loadings}) to color points by.}

\item{annotate_top_n}{Annotate the top n features with positive or negative loading}

\item{highlight_genes}{Vector of gene names or gene IDs to highlight on the plot (overwrites top_n annotation)}

\item{show_plot}{Whether to show the plot}
}
\value{
The function displays the loadings plot and returns invisible a list of the plot,
the data.frame of the PCA loadings.
}
\description{
Plot loadings of a principal component
}
\examples{
set.seed(1)
data <- matrix(rnorm(100*6), ncol=6)
data <- t(t(data)+c(-1, -1.1, -1.2, 1, 1.1, 1.2))
pca_res <- plot_pca(data)
plot_loadings(pca_res)
}
