% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_net.R
\name{GLMnetwork}
\alias{GLMnetwork}
\title{Infer a network from RNA-seq expression.}
\usage{
GLMnetwork(counts, lambdas = NULL, normalize = TRUE)
}
\arguments{
\item{counts}{a n x p matrix of RNA-seq expression (numeric matrix or data
frame)}

\item{lambdas}{a sequence of decreasing positive numbers to control the
regularization (numeric vector). Default to \code{NULL}}

\item{normalize}{logical value to normalize predictors in the log-linear
Poisson graphical model. If \code{TRUE}, log normalization and scaling are
performed prior the model is fit. Default to \code{TRUE}}
}
\value{
S3 object of class \code{GLMnetwork}: a list consisting of
\itemize{
  \item{\code{lambda}}{ regularization parameters used for LLGM path(vector)}
  \item{\code{path}}{ a list having the same length than \code{lambda}. It
  contains the estimated coefficients (in a matrix) along the path}
 }
}
\description{
\code{GLMnetwork} infers a network from RNA-seq expression with the
log-linear Poisson graphical model of (Allen and Liu, 2012).
}
\details{
When input \code{lambdas} are null the default sequence of
\code{\link[glmnet]{glmnet}} for the first model (the one with the first
column of \code{count} as the target) is used.
}
\examples{
data(lung)
lambdas <- 4 * 10^(seq(0, -2, length = 10))
ref_lung <- GLMnetwork(lung, lambdas = lambdas)

}
\references{
{Allen, G. and Liu, Z. (2012) A log-linear model for inferring
genetic networks from high-throughput sequencing data. In \emph{Proceedings
of IEEE International Conference on Bioinformatics and Biomedecine (BIBM)}.}
}
\seealso{
\code{\link{stabilitySelection}}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
