% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donors.R
\name{varIntra}
\alias{varIntra}
\title{Average intra-donor pool variance.}
\usage{
varIntra(X, Y, donors)
}
\arguments{
\item{X}{n x p numeric matrix containing RNA-seq expression with missing rows
(numeric matrix or data frame)}

\item{Y}{auxiliary dataset (n' x q numeric matrix or data frame)}

\item{donors}{donor pool (a list, as given \code{$donors} obtained from the
function \code{\link{imputeHD}})}
}
\value{
\code{varIntra} returns a numeric value which is the average
intra-donor pool variance, as described in (Imbert \emph{et al.}, 2017).
}
\description{
\code{varIntra} computes the average intra-donor pool variance.
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
\references{
{Imbert, A., Le Gall, C., Armenise, C., Lefebvre, G., Hager, J.,
Valsesia, A., Gourraud, P.A., Viguerie, N. and Villa-Vialaneix, N. (2017)
Multiple hot-deck imputation for network inference from RNA sequencing data.
\emph{Preprint}.}
}
\seealso{
\code{\link{imputeHD}}, \code{\link{chooseSigma}}
}

