/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;

public class DBRefBase {
    final Object _id;
    final String _ns;
    final DB _db;
    private boolean _loadedPointedTo = false;
    private DBObject _pointedTo;

    public DBRefBase(DB db, String ns, Object id) {
        this._db = db;
        this._ns = ns.intern();
        this._id = id;
    }

    public DBObject fetch() throws MongoException {
        if (this._loadedPointedTo) {
            return this._pointedTo;
        }
        if (this._db == null) {
            throw new RuntimeException("no db");
        }
        DBCollection coll = this._db.getCollectionFromString(this._ns);
        this._pointedTo = coll.findOne(this._id);
        this._loadedPointedTo = true;
        return this._pointedTo;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this._ns + "\", \"$id\" : \"" + this._id + "\" }";
    }

    public Object getId() {
        return this._id;
    }

    public String getRef() {
        return this._ns;
    }

    public DB getDB() {
        return this._db;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBRefBase dbRefBase = (DBRefBase)o;
        if (this._id != null ? !this._id.equals(dbRefBase._id) : dbRefBase._id != null) {
            return false;
        }
        return !(this._ns != null ? !this._ns.equals(dbRefBase._ns) : dbRefBase._ns != null);
    }

    public int hashCode() {
        int result2 = this._id != null ? this._id.hashCode() : 0;
        result2 = 31 * result2 + (this._ns != null ? this._ns.hashCode() : 0);
        return result2;
    }
}

