% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_methods.R
\name{print.MixtComp}
\alias{print.MixtComp}
\title{Print Values}
\usage{
\method{print}{MixtComp}(x, nVarMaxToPrint = 5, ...)
}
\arguments{
\item{x}{\emph{MixtComp} object}

\item{nVarMaxToPrint}{number of variables to display (including z_class)}

\item{...}{parameter of \code{head} function}
}
\description{
Print a \emph{MixtComp} object
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
                  var2 = as.character(c(rnorm(50, 2), rpois(50, 8))))
                  
model <- list(var1 = list(type = "Gaussian", paramStr = ""),
              var2 = list(type = "Poisson", paramStr = ""))

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

print(resLearn)

}
\seealso{
\code{mixtCompLearn} \code{mixtCompPredict}
}
\author{
Quentin Grimonprez
}
