% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPConnection.R
\docType{class}
\name{KorAPConnection-class}
\alias{KorAPConnection-class}
\alias{KorAPConnection}
\alias{initialize,KorAPConnection-method}
\alias{persistAccessToken,KorAPConnection-method}
\alias{persistAccessToken}
\alias{clearAccessToken,KorAPConnection-method}
\alias{clearAccessToken}
\alias{apiCall,KorAPConnection-method}
\alias{apiCall}
\alias{clearCache,KorAPConnection-method}
\alias{clearCache}
\alias{show,KorAPConnection-method}
\title{Class KorAPConnection}
\usage{
\S4method{initialize}{KorAPConnection}(
  .Object,
  KorAPUrl = "https://korap.ids-mannheim.de/",
  apiVersion = "v1.0",
  apiUrl,
  accessToken = getAccessToken(KorAPUrl),
  userAgent = "R-KorAP-Client",
  timeout = 240,
  verbose = FALSE,
  cache = TRUE
)

\S4method{persistAccessToken}{KorAPConnection}(kco, accessToken = kco@accessToken)

\S4method{clearAccessToken}{KorAPConnection}(kco)

\S4method{apiCall}{KorAPConnection}(
  kco,
  url,
  json = TRUE,
  getHeaders = FALSE,
  cache = kco@cache,
  timeout = kco@timeout
)

\S4method{clearCache}{KorAPConnection}(kco)

\S4method{show}{KorAPConnection}(object)
}
\arguments{
\item{.Object}{KorAPConnection object}

\item{KorAPUrl}{URL of the web user interface of the KorAP server instance you want to access.}

\item{apiVersion}{which version of KorAP's API you want to connect to.}

\item{apiUrl}{URL of the KorAP web service.}

\item{accessToken}{OAuth2 access token. For queries on corpus parts with restricted
access (e.g. textual queries on IPR protected data), you need to authorize
your application with an access token.
How to obtain an access token for the DeReKo KorAP instance is explained in the
\href{https://github.com/KorAP/RKorAPClient#authorization}{authorization section}
of the RKorAPClient Readme on GitHub.

To use authorization based on an access token
in subsequent queries, initialize your KorAP connection with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{kco <- new("KorAPConnection", accessToken="<access token>")
}\if{html}{\out{</div>}}

In order to make the API
token persistent for the currently used \code{KorAPUrl} (you can have one
token per KorAPUrl / KorAP server instance), use:

\if{html}{\out{<div class="sourceCode">}}\preformatted{persistAccessToken(kco)
}\if{html}{\out{</div>}}

This will store it in your keyring using the
\link[keyring:keyring-package]{keyring::keyring-package}. Subsequent new("KorAPConnection") calls will
then automatically retrieve the token from your keying. To stop using a
persisted token, call \code{clearAccessToken(kco)}. Please note that for
DeReKo, authorized queries will behave differently inside and outside the
IDS, because of the special license situation. This concerns also cached
results which do not take into account from where a request was issued. If
you experience problems or unexpected results, please try \code{kco <- new("KorAPConnection", cache=FALSE)} or use
\code{\link[=clearCache]{clearCache()}} to clear the cache completely.}

\item{userAgent}{user agent string.}

\item{timeout}{tineout in seconds for API requests (this does not influence server internal timeouts).}

\item{verbose}{logical that decides whether following operations will default to
be verbose.}

\item{cache}{logical that decides if API calls are cached locally. You can clear
the cache with \code{\link[=clearCache]{clearCache()}}.}

\item{kco}{KorAPConnection object}

\item{url}{request url}

\item{json}{logical that determines if json result is expected}

\item{getHeaders}{logical that determines if headers and content should be returned (as a list)}

\item{object}{KorAPConnection object}
}
\value{
\code{\link[=KorAPConnection]{KorAPConnection()}} object that can be used e.g. with
\code{\link[=corpusQuery]{corpusQuery()}}
}
\description{
\code{KorAPConnection} objects represent the connection to a KorAP server.
New \code{KorAPConnection} objects can be created by \code{new("KorAPConnection")}.
}
\section{Slots}{

\describe{
\item{\code{KorAPUrl}}{URL of the web user interface of the KorAP server used in the connection.}

\item{\code{apiVersion}}{requested KorAP API version.}

\item{\code{indexRevision}}{indexRevision code as reported from API via \code{X-Index-Revision} HTTP header.}

\item{\code{apiUrl}}{full URL of API including version.}

\item{\code{accessToken}}{OAuth2 access token.}

\item{\code{userAgent}}{user agent string used for connection the API.}

\item{\code{timeout}}{tineout in seconds for API requests (this does not influence server internal timeouts)}

\item{\code{verbose}}{logical that decides whether operations will default to be verbose.}

\item{\code{cache}}{logical that decides if API calls are cached locally.}

\item{\code{welcome}}{list containing HTTP response received from KorAP server welcome function.}
}}

\examples{
\dontrun{

kcon <- new("KorAPConnection", verbose = TRUE)
kq <- corpusQuery(kcon, "Ameisenplage")
kq <- fetchAll(kq)
}

\dontrun{

kcon <- new("KorAPConnection", verbose = TRUE, accessToken="e739u6eOzkwADQPdVChxFg")
kq <- corpusQuery(kcon, "Ameisenplage", metadataOnly=FALSE)
kq <- fetchAll(kq)
kq@collectedMatches$snippet
}

\dontrun{

kco <- new("KorAPConnection", accessToken="e739u6eOzkwADQPdVChxFg")
persistAccessToken(kco)
}

\dontrun{

kco <- new("KorAPConnection")
clearAccessToken(kco)
}

}
