/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

public abstract class HashCommon {
    protected static final double loadFactor = 0.5;
    protected Object[] keys;
    protected int capacity;
    protected int threshold;
    protected int size = 0;
    static final int[] primes = new int[]{7, 19, 37, 79, 149, 307, 617, 1237, 2477, 4957, 9923, 19853, 39709, 79423, 158849, 317701, 635413, 1270849, 2541701, 5083423};

    protected HashCommon(int initialCapacity) {
        this.capacity = initialCapacity;
        this.keys = new Object[this.capacity];
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    public Object getItemForTestingAt(int i) {
        return this.keys[i];
    }

    protected final int initialIndexFor(Object key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
    }

    protected final int findSlot(Object key) {
        int index = this.initialIndexFor(key);
        Object current;
        while ((current = this.keys[index]) != null) {
            if (key.equals(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    protected void growCapacityAndThreshold() {
        this.capacity = HashCommon.nextSize(this.capacity * 2);
        this.threshold = (int)((double)this.capacity * 0.5);
    }

    protected static int nextSize(int atLeast) {
        for (int i = 0; i < primes.length; ++i) {
            if (primes[i] <= atLeast) continue;
            return primes[i];
        }
        return atLeast;
    }

    protected void removeFrom(int here) {
        while (true) {
            Object key;
            int r;
            this.keys[here] = null;
            this.removeAssociatedValues(here);
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.capacity;
                }
                if ((key = this.keys[scan]) != null) continue;
                return;
            } while (scan <= (r = this.initialIndexFor(key)) && r < here || r < here && here < scan || here < scan && scan <= r);
            this.keys[here] = this.keys[scan];
            this.moveAssociatedValues(here, scan);
            here = scan;
        }
    }

    protected void removeAssociatedValues(int here) {
    }

    protected void moveAssociatedValues(int here, int scan) {
    }
}

