/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

public class Tokenizer {
    private String m_str;
    private int m_cur = 0;
    private char m_delimiter;
    private boolean m_ws;

    public Tokenizer(String s) {
        this.m_str = s;
        this.m_ws = true;
    }

    public Tokenizer(String s, char delimiter) {
        this.m_str = s;
        this.m_ws = false;
        this.m_delimiter = delimiter;
    }

    public boolean hasNextToken() {
        if (this.m_ws) {
            while (this.m_cur < this.m_str.length() && Character.isWhitespace(this.m_str.charAt(this.m_cur))) {
                ++this.m_cur;
            }
            return this.m_cur < this.m_str.length();
        }
        return this.m_cur < this.m_str.length();
    }

    public String nextToken() {
        int cur = this.m_cur;
        if (this.m_ws) {
            while (this.m_cur < this.m_str.length() && !Character.isWhitespace(this.m_str.charAt(this.m_cur))) {
                ++this.m_cur;
            }
            String sub = this.m_str.substring(cur, this.m_cur);
            return sub;
        }
        while (this.m_cur < this.m_str.length() && this.m_str.charAt(this.m_cur) != this.m_delimiter) {
            ++this.m_cur;
        }
        String sub = this.m_str.substring(cur, this.m_cur++);
        return sub;
    }
}

