/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.polynomials.LeastSquaresDivision;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.ParametersRange;
import ec.tstoolkit.maths.realfunctions.SingleParameter;

class Function
implements IFunction {
    double[] p;
    int start;

    Function(double[] p, int start) {
        this.p = p;
        this.start = start;
    }

    @Override
    public IFunctionInstance evaluate(IReadDataBlock parameters) {
        return new FunctionInstance(parameters.get(0));
    }

    public IFunctionInstance evaluate(double a) {
        return new FunctionInstance(a);
    }

    @Override
    public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
        return new NumericalDerivatives(this, point, true);
    }

    @Override
    public IParametersDomain getDomain() {
        return new ParametersRange(-1.0, 1.0, true);
    }

    class FunctionInstance
    implements IFunctionInstance {
        double x;
        LeastSquaresDivision lq;

        FunctionInstance(double x) {
            this.x = x;
        }

        @Override
        public IReadDataBlock getParameters() {
            return new SingleParameter(this.x);
        }

        public double getX() {
            return this.x;
        }

        @Override
        public double getValue() {
            double a = -2.0 * this.x;
            Polynomial num = Polynomial.copyOf(Function.this.p, Function.this.start, Function.this.p.length);
            Polynomial div = Polynomial.of(new double[]{1.0, a, 1.0});
            div = div.times(div);
            this.lq = new LeastSquaresDivision();
            this.lq.divide(num, div);
            return this.lq.getError() / (double)(num.getLength() - div.getLength());
        }
    }
}

