/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;
import ec.tstoolkit.random.XorshiftRNG;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class SarimaModelBuilder {
    private static IRandomNumberGenerator RNG = XorshiftRNG.fromSystemNanoTime();
    private IRandomNumberGenerator rng = RNG;

    public void setRandomNumberGenerator(IRandomNumberGenerator rng) {
        this.rng = rng;
    }

    public IRandomNumberGenerator getRandomNumberGenerator() {
        return this.rng;
    }

    public SarimaModel createAirlineModel(int frequency, double th, double bth) {
        try {
            SarimaSpecification spec = new SarimaSpecification(frequency);
            spec.airline();
            SarimaModel model = new SarimaModel(spec);
            model.setTheta(1, th);
            model.setBTheta(1, bth);
            return model;
        }
        catch (ArimaException e) {
            throw new RuntimeException(e);
        }
    }

    public SarimaModel createArimaModel(int frequency, int p, int d, int q, int bp, int bd, int bq) {
        try {
            SarimaSpecification spec = new SarimaSpecification(frequency);
            spec.setP(p);
            spec.setD(d);
            spec.setQ(q);
            spec.setBP(bp);
            spec.setBD(bd);
            spec.setBQ(bq);
            return new SarimaModel(spec);
        }
        catch (ArimaException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized double next(double e) {
        return StochasticRandomizer.normal(this.rng, 0.0, e);
    }

    public SarimaModel randomize(SarimaModel spec, double stdev) {
        if (stdev <= 0.0) {
            return spec;
        }
        SarimaModel model = null;
        do {
            model = spec.clone();
            DataBlock p = new DataBlock(spec.getParameters());
            for (int i = 0; i < p.getLength(); ++i) {
                double v = p.get(i);
                p.set(i, v += this.next(stdev));
            }
            model.setParameters(p);
        } while (!model.isValid(true));
        return model;
    }

    public SarimaModel createArmaModel(int frequency, int p, int q, int bp, int bq) {
        try {
            SarimaSpecification spec = new SarimaSpecification(frequency);
            spec.setP(p);
            spec.setD(0);
            spec.setQ(q);
            spec.setBP(bp);
            spec.setBD(0);
            spec.setBQ(bq);
            return new SarimaModel(spec);
        }
        catch (ArimaException e) {
            throw new RuntimeException(e);
        }
    }
}

