/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.AbstractTsModifier;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.ArrayList;
import java.util.List;

public class TsVariableWindow
extends AbstractTsModifier {
    private final Day start;
    private final Day end;

    public TsVariableWindow(ITsVariable var, Day start, Day end) {
        super(var);
        this.start = start;
        this.end = end;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        TsPeriodSelector sel = new TsPeriodSelector();
        sel.between(this.start, this.end);
        TsDomain sdom = domain.select(sel);
        int nbeg = sdom.getStart().minus(domain.getStart());
        int n = sdom.getLength();
        if (n == 0) {
            return;
        }
        ArrayList<DataBlock> tmp = new ArrayList<DataBlock>();
        for (DataBlock bl : data) {
            tmp.add(bl.extract(nbeg, n));
        }
        this.var.data(sdom, tmp);
    }

    private String description(String desc) {
        StringBuilder builder = new StringBuilder();
        builder.append(desc);
        builder.append('(').append(this.start.toString()).append("//");
        builder.append(this.end.toString()).append(')');
        return builder.toString();
    }

    public Day getStart() {
        return this.start;
    }

    public Day getEnd() {
        return this.end;
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return this.var.getDefinitionDomain();
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.var.getDefinitionFrequency();
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.description(this.var.getDescription(context) + this.getDescription(context));
    }

    @Override
    public int getDim() {
        return this.var.getDim();
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        return this.description(this.var.getItemDescription(idx, context));
    }

    @Override
    public ITsVariable getVariable() {
        return this.var;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        TsPeriodSelector sel = new TsPeriodSelector();
        sel.between(this.start, this.end);
        TsDomain sdom = domain.select(sel);
        return !sdom.isEmpty();
    }

    @Override
    public String getName() {
        return this.var.getName();
    }
}

