/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.image.IndexColorModel;

public class LUT
extends IndexColorModel
implements Cloneable {
    public double min;
    public double max;

    public LUT(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(8, 256, byArray, byArray2, byArray3);
    }

    public LUT(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, n2, byArray, byArray2, byArray3);
    }

    public LUT(IndexColorModel indexColorModel, double d, double d2) {
        super(8, indexColorModel.getMapSize(), LUT.getReds(indexColorModel), LUT.getGreens(indexColorModel), LUT.getBlues(indexColorModel));
        this.min = d;
        this.max = d2;
    }

    static byte[] getReds(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        indexColorModel.getReds(byArray);
        return byArray;
    }

    static byte[] getGreens(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        indexColorModel.getGreens(byArray);
        return byArray;
    }

    static byte[] getBlues(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        indexColorModel.getBlues(byArray);
        return byArray;
    }

    public byte[] getBytes() {
        int n;
        int n2 = this.getMapSize();
        if (n2 != 256) {
            return null;
        }
        byte[] byArray = new byte[768];
        for (n = 0; n < 256; ++n) {
            byArray[n] = (byte)this.getRed(n);
        }
        for (n = 0; n < 256; ++n) {
            byArray[256 + n] = (byte)this.getGreen(n);
        }
        for (n = 0; n < 256; ++n) {
            byArray[512 + n] = (byte)this.getBlue(n);
        }
        return byArray;
    }

    public LUT createInvertedLut() {
        int n = this.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        this.getReds(byArray);
        this.getGreens(byArray2);
        this.getBlues(byArray3);
        for (int i = 0; i < n; ++i) {
            byArray4[i] = (byte)(byArray[n - i - 1] & 0xFF);
            byArray5[i] = (byte)(byArray2[n - i - 1] & 0xFF);
            byArray6[i] = (byte)(byArray3[n - i - 1] & 0xFF);
        }
        return new LUT(8, n, byArray4, byArray5, byArray6);
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

