/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.Prefs;
import ij.gui.OvalRoi;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.GaussianBlur;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageStatistics;
import ij.process.PolygonFiller;
import ij.process.TypeConverter;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public abstract class ImageProcessor {
    public static final int BLACK = -16777216;
    public static final double NO_THRESHOLD = -808080.0;
    public static final int LEFT_JUSTIFY = 0;
    public static final int CENTER_JUSTIFY = 1;
    public static final int RIGHT_JUSTIFY = 2;
    public static final int ISODATA = 0;
    public static final int ISODATA2 = 1;
    public static final int NEAREST_NEIGHBOR = 0;
    public static final int NONE = 0;
    public static final int BILINEAR = 1;
    public static final int BICUBIC = 2;
    public static final int BLUR_MORE = 0;
    public static final int FIND_EDGES = 1;
    public static final int MEDIAN_FILTER = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int CONVOLVE = 5;
    public static final int RED_LUT = 0;
    public static final int BLACK_AND_WHITE_LUT = 1;
    public static final int NO_LUT_UPDATE = 2;
    public static final int OVER_UNDER_LUT = 3;
    static final int INVERT = 0;
    static final int FILL = 1;
    static final int ADD = 2;
    static final int MULT = 3;
    static final int AND = 4;
    static final int OR = 5;
    static final int XOR = 6;
    static final int GAMMA = 7;
    static final int LOG = 8;
    static final int MINIMUM = 9;
    static final int MAXIMUM = 10;
    static final int SQR = 11;
    static final int SQRT = 12;
    static final int EXP = 13;
    static final int ABS = 14;
    static final String WRONG_LENGTH = "width*height!=pixels.length";
    int fgColor = 0;
    protected int lineWidth = 1;
    protected int cx;
    protected int cy;
    protected Font font;
    protected FontMetrics fontMetrics;
    protected boolean antialiasedText;
    protected boolean boldFont;
    private static String[] interpolationMethods;
    private static int overRed;
    private static int overGreen;
    private static int overBlue;
    private static int underRed;
    private static int underGreen;
    private static int underBlue;
    private static boolean useBicubic;
    private int sliceNumber;
    ProgressBar progressBar;
    protected int width;
    protected int snapshotWidth;
    protected int height;
    protected int snapshotHeight;
    protected int roiX;
    protected int roiY;
    protected int roiWidth;
    protected int roiHeight;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    boolean snapshotCopyMode;
    ImageProcessor mask;
    protected ColorModel baseCM;
    protected ColorModel cm;
    protected byte[] rLUT1;
    protected byte[] gLUT1;
    protected byte[] bLUT1;
    protected byte[] rLUT2;
    protected byte[] gLUT2;
    protected byte[] bLUT2;
    protected boolean interpolate;
    protected int interpolationMethod = 0;
    protected double minThreshold = -808080.0;
    protected double maxThreshold = -808080.0;
    protected int histogramSize = 256;
    protected double histogramMin;
    protected double histogramMax;
    protected float[] cTable;
    protected boolean lutAnimation;
    protected MemoryImageSource source;
    protected Image img;
    protected boolean newPixels;
    protected Color drawingColor = Color.black;
    protected int clipXMin;
    protected int clipXMax;
    protected int clipYMin;
    protected int clipYMax;
    protected int justification = 0;
    protected int lutUpdateMode;
    protected WritableRaster raster;
    protected BufferedImage image;
    protected BufferedImage fmImage;
    protected ColorModel cm2;
    protected SampleModel sampleModel;
    protected static IndexColorModel defaultColorModel;
    protected boolean minMaxSet;
    protected boolean inversionTested = false;
    protected boolean invertedLut;
    private ImageProcessor dotMask;
    static final double a = 0.5;
    private byte[] bytes;
    private int[] reds;
    private int[] greens;
    private int[] blues;

    protected void showProgress(double d) {
        if (this.progressBar != null) {
            this.progressBar.show(d);
        }
    }

    protected void hideProgress() {
        this.showProgress(1.0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.baseCM != null) {
            return this.baseCM;
        }
        return this.cm;
    }

    public ColorModel getCurrentColorModel() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        return this.cm;
    }

    public void setColorModel(ColorModel colorModel) {
        if (!(this instanceof ColorProcessor) && !(colorModel instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Must be IndexColorModel");
        }
        this.cm = colorModel;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.newPixels = true;
        this.inversionTested = false;
        this.minThreshold = -808080.0;
        this.source = null;
    }

    protected void makeDefaultColorModel() {
        this.cm = this.getDefaultColorModel();
    }

    public void invertLut() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < n; ++i) {
            byArray4[i] = (byte)(byArray[n - i - 1] & 0xFF);
            byArray5[i] = (byte)(byArray2[n - i - 1] & 0xFF);
            byArray6[i] = (byte)(byArray3[n - i - 1] & 0xFF);
        }
        IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray4, byArray5, byArray6);
        this.setColorModel(indexColorModel2);
    }

    public int getBestIndex(Color color) {
        IndexColorModel indexColorModel;
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.minThreshold != -808080.0) {
            double d = this.getMinThreshold();
            double d2 = this.getMaxThreshold();
            this.resetThreshold();
            indexColorModel = (IndexColorModel)this.cm;
            this.setThreshold(d, d2, this.lutUpdateMode);
        } else {
            indexColorModel = (IndexColorModel)this.cm;
        }
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        for (int i = 0; i < n; ++i) {
            int n7 = byArray[i] & 0xFF;
            int n8 = byArray2[i] & 0xFF;
            int n9 = byArray3[i] & 0xFF;
            int n10 = (n7 - n4) * (n7 - n4) + (n8 - n5) * (n8 - n5) + (n9 - n6) * (n9 - n6);
            if (n10 < n2) {
                n2 = n10;
                n3 = i;
            }
            if ((double)n2 == 0.0) break;
        }
        return n3;
    }

    public boolean isInvertedLut() {
        if (this.inversionTested) {
            return this.invertedLut;
        }
        this.inversionTested = true;
        if (this.cm == null || !(this.cm instanceof IndexColorModel)) {
            this.invertedLut = false;
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        this.invertedLut = true;
        for (int i = 1; i < 255; ++i) {
            int n;
            int n2 = indexColorModel.getRed(i - 1) + indexColorModel.getGreen(i - 1) + indexColorModel.getBlue(i - 1);
            if (n2 >= (n = indexColorModel.getRed(i) + indexColorModel.getGreen(i) + indexColorModel.getBlue(i))) continue;
            this.invertedLut = false;
            break;
        }
        return this.invertedLut;
    }

    public boolean isColorLut() {
        if (this.cm == null || !(this.cm instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i] && byArray2[i] == byArray3[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isPseudoColorLut() {
        boolean bl;
        if (this.cm == null || !(this.cm instanceof IndexColorModel)) {
            return false;
        }
        if (this.getMinThreshold() != -808080.0) {
            return true;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        if (n != 256) {
            return false;
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray2[0] & 0xFF;
        int n4 = byArray3[0] & 0xFF;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n5 = byArray[i] & 0xFF;
            int n6 = byArray2[i] & 0xFF;
            int n7 = byArray3[i] & 0xFF;
            int n8 = n5 - n2;
            d += (double)n8;
            d2 += (double)(n8 * n8);
            n8 = n6 - n3;
            d += (double)n8;
            d2 += (double)(n8 * n8);
            n8 = n7 - n4;
            d += (double)n8;
            d2 += (double)(n8 * n8);
            n2 = n5;
            n3 = n6;
            n4 = n7;
        }
        double d3 = (768.0 * d2 - d * d) / 768.0;
        d3 = d3 > 0.0 ? Math.sqrt(d3 / 767.0) : 0.0;
        boolean bl2 = bl = d3 < 20.0;
        if ((int)d3 == 67) {
            bl = true;
        }
        if (IJ.debugMode) {
            IJ.log("isPseudoColorLut: " + bl + " " + d3);
        }
        return bl;
    }

    public boolean isDefaultLut() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (!(this.cm instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n = indexColorModel.getMapSize();
        if (n != 256) {
            return false;
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) == i && (byArray2[i] & 0xFF) == i && (byArray3[i] & 0xFF) == i) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public abstract void setColor(Color var1);

    public void setColor(int n) {
        this.setValue(n);
    }

    public abstract void setValue(double var1);

    public abstract void setBackgroundValue(double var1);

    public abstract double getBackgroundValue();

    public abstract double getMin();

    public abstract double getMax();

    public abstract void setMinAndMax(double var1, double var3);

    public void resetMinAndMax() {
    }

    public void setThreshold(double d, double d2, int n) {
        if (this instanceof ColorProcessor) {
            return;
        }
        this.minThreshold = d;
        this.maxThreshold = d2;
        this.lutUpdateMode = n;
        if (d == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (n == 2) {
            return;
        }
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            indexColorModel.getReds(this.rLUT1);
            indexColorModel.getGreens(this.gLUT1);
            indexColorModel.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int n2 = (int)d;
        int n3 = (int)d2;
        if (n == 0) {
            for (int i = 0; i < 256; ++i) {
                if (i >= n2 && i <= n3) {
                    this.rLUT2[i] = -1;
                    this.gLUT2[i] = 0;
                    this.bLUT2[i] = 0;
                    continue;
                }
                this.rLUT2[i] = this.rLUT1[i];
                this.gLUT2[i] = this.gLUT1[i];
                this.bLUT2[i] = this.bLUT1[i];
            }
        } else if (n == 1) {
            int n4 = Prefs.blackBackground ? -1 : 0;
            byte by = (byte)(255 - n4);
            for (int i = 0; i < 256; ++i) {
                if (i >= n2 && i <= n3) {
                    this.rLUT2[i] = n4;
                    this.gLUT2[i] = n4;
                    this.bLUT2[i] = n4;
                    continue;
                }
                this.rLUT2[i] = by;
                this.gLUT2[i] = by;
                this.bLUT2[i] = by;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                if (i >= n2 && i <= n3) {
                    this.rLUT2[i] = this.rLUT1[i];
                    this.gLUT2[i] = this.gLUT1[i];
                    this.bLUT2[i] = this.bLUT1[i];
                    continue;
                }
                if (i > n3) {
                    this.rLUT2[i] = (byte)overRed;
                    this.gLUT2[i] = (byte)overGreen;
                    this.bLUT2[i] = (byte)overBlue;
                    continue;
                }
                this.rLUT2[i] = (byte)underRed;
                this.gLUT2[i] = (byte)underGreen;
                this.bLUT2[i] = (byte)underBlue;
            }
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
        this.source = null;
    }

    public void setAutoThreshold(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null method");
        }
        boolean bl = string.indexOf("dark") != -1;
        int n = string.indexOf(" ");
        if (n != -1) {
            string = string.substring(0, n);
        }
        this.setAutoThreshold(string, bl, 0);
    }

    public void setAutoThreshold(String string, boolean bl, int n) {
        AutoThresholder.Method method = null;
        try {
            method = AutoThresholder.Method.valueOf(AutoThresholder.Method.class, string);
        }
        catch (Exception exception) {
            method = null;
        }
        if (method == null) {
            throw new IllegalArgumentException("Invalid method (\"" + string + "\")");
        }
        this.setAutoThreshold(method, bl, n);
    }

    public void setAutoThreshold(AutoThresholder.Method method, boolean bl) {
        this.setAutoThreshold(method, bl, 0);
    }

    public void setAutoThreshold(AutoThresholder.Method method, boolean bl, int n) {
        double d;
        double d2;
        Object object;
        if (method == null || this instanceof ColorProcessor) {
            return;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl2 = !(this instanceof ByteProcessor);
        ImageProcessor imageProcessor = this;
        if (bl2) {
            ImageProcessor imageProcessor2 = imageProcessor.getMask();
            object = imageProcessor.getRoi();
            this.resetMinAndMax();
            d3 = this.getMin();
            d4 = this.getMax();
            imageProcessor = this.convertToByte(true);
            imageProcessor.setMask(imageProcessor2);
            imageProcessor.setRoi((Rectangle)object);
        }
        int n2 = 25;
        object = ImageStatistics.getStatistics(imageProcessor, n2, null);
        AutoThresholder autoThresholder = new AutoThresholder();
        int n3 = autoThresholder.getThreshold(method, ((ImageStatistics)object).histogram);
        if (bl) {
            if (this.isInvertedLut()) {
                d2 = 0.0;
                d = n3;
            } else {
                d2 = n3 + 1;
                d = 255.0;
            }
        } else if (this.isInvertedLut()) {
            d2 = n3 + 1;
            d = 255.0;
        } else {
            d2 = 0.0;
            d = n3;
        }
        if (d2 > 255.0) {
            d2 = 255.0;
        }
        if (bl2) {
            if (d4 > d3) {
                d2 = d3 + d2 / 255.0 * (d4 - d3);
                d = d3 + d / 255.0 * (d4 - d3);
            } else {
                d2 = d = d3;
            }
        }
        this.setThreshold(d2, d, n);
    }

    public void setAutoThreshold(int n, int n2) {
        double d;
        double d2;
        int n3;
        Object object;
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Invalid thresholding method");
        }
        if (this instanceof ColorProcessor) {
            return;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = !(this instanceof ByteProcessor);
        ImageProcessor imageProcessor = this;
        if (bl) {
            ImageProcessor imageProcessor2 = imageProcessor.getMask();
            object = imageProcessor.getRoi();
            this.resetMinAndMax();
            d3 = this.getMin();
            d4 = this.getMax();
            imageProcessor = this.convertToByte(true);
            imageProcessor.setMask(imageProcessor2);
            imageProcessor.setRoi((Rectangle)object);
        }
        int n4 = 25;
        object = ImageStatistics.getStatistics(imageProcessor, n4, null);
        int[] nArray = ((ImageStatistics)object).histogram;
        int n5 = nArray[((ImageStatistics)object).mode];
        if (n == 1) {
            int n6;
            n3 = 0;
            for (n6 = 0; n6 < ((ImageStatistics)object).nBins; ++n6) {
                if (nArray[n6] <= n3 || n6 == ((ImageStatistics)object).mode) continue;
                n3 = nArray[n6];
            }
            n6 = ((ImageStatistics)object).maxCount;
            if (n6 > n3 * 2 && n3 != 0) {
                nArray[((ImageStatistics)object).mode] = n6 = (int)((double)n3 * 1.5);
            }
        }
        n3 = imageProcessor.getAutoThreshold(((ImageStatistics)object).histogram);
        nArray[((ImageStatistics)object).mode] = n5;
        float[] fArray = new float[256];
        for (int i = 0; i < 256; ++i) {
            fArray[i] = ((ImageStatistics)object).histogram[i];
        }
        FloatProcessor floatProcessor = new FloatProcessor(256, 1, fArray, null);
        GaussianBlur gaussianBlur = new GaussianBlur();
        gaussianBlur.blur1Direction(floatProcessor, 2.0, 0.01, true, 0);
        float f = 0.0f;
        float f2 = 0.0f;
        int n7 = 0;
        for (int i = 0; i < 256; ++i) {
            float f3 = fArray[i];
            f2 += f3;
            if (!(f3 > f)) continue;
            f = f3;
            n7 = i;
        }
        double d5 = (double)f2 / 256.0;
        if ((double)f / d5 > 1.5) {
            if (((ImageStatistics)object).max - (double)n7 > (double)n7 - ((ImageStatistics)object).min) {
                d2 = n3;
                d = 255.0;
            } else {
                d2 = 0.0;
                d = n3;
            }
        } else if (this.isInvertedLut()) {
            d2 = n3;
            d = 255.0;
        } else {
            d2 = 0.0;
            d = n3;
        }
        if (bl) {
            if (d4 > d3) {
                d2 = d3 + d2 / 255.0 * (d4 - d3);
                d = d3 + d / 255.0 * (d4 - d3);
            } else {
                d2 = d = d3;
            }
        }
        this.setThreshold(d2, d, n2);
    }

    public void resetThreshold() {
        this.minThreshold = -808080.0;
        if (this.baseCM != null) {
            this.cm = this.baseCM;
            this.baseCM = null;
        }
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
        this.newPixels = true;
        this.source = null;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public int getLutUpdateMode() {
        return this.lutUpdateMode;
    }

    public void setBinaryThreshold() {
        if (!(this instanceof ByteProcessor)) {
            return;
        }
        double d = 255.0;
        double d2 = 255.0;
        boolean bl = this.isInvertedLut();
        if (bl && Prefs.blackBackground || !bl && !Prefs.blackBackground) {
            d = 0.0;
            d2 = 0.0;
        }
        this.setThreshold(d, d2, 2);
    }

    public void resetBinaryThreshold() {
        if (this.minThreshold == this.maxThreshold && this.lutUpdateMode == 2) {
            this.resetThreshold();
        }
    }

    public void setRoi(Rectangle rectangle) {
        if (rectangle == null) {
            this.resetRoi();
        } else {
            this.setRoi(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setRoi(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = rectangle.intersection(new Rectangle(0, 0, this.width, this.height));
            if (rectangle2.width <= 0 || rectangle2.height <= 0) {
                this.roiX = 0;
                this.roiY = 0;
                this.roiWidth = 0;
                this.roiHeight = 0;
                this.xMin = 0;
                this.xMax = 0;
                this.yMin = 0;
                this.yMax = 0;
                this.mask = null;
                return;
            }
            if (this.mask != null && this.mask.getWidth() == n3 && this.mask.getHeight() == n4) {
                Rectangle rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
                if (n < 0) {
                    rectangle3.x = -n;
                }
                if (n2 < 0) {
                    rectangle3.y = -n2;
                }
                this.mask.setRoi(rectangle3);
                this.mask = this.mask.crop();
            }
            this.roiX = rectangle2.x;
            this.roiY = rectangle2.y;
            this.roiWidth = rectangle2.width;
            this.roiHeight = rectangle2.height;
        } else {
            this.roiX = n;
            this.roiY = n2;
            this.roiWidth = n3;
            this.roiHeight = n4;
        }
        if (this.mask != null && (this.mask.getWidth() != this.roiWidth || this.mask.getHeight() != this.roiHeight)) {
            this.mask = null;
        }
        this.xMin = Math.max(this.roiX, 1);
        this.xMax = Math.min(this.roiX + this.roiWidth - 1, this.width - 2);
        this.yMin = Math.max(this.roiY, 1);
        this.yMax = Math.min(this.roiY + this.roiHeight - 1, this.height - 2);
    }

    public void setRoi(Roi roi) {
        if (roi == null) {
            this.resetRoi();
        } else {
            this.setMask(roi.getMask());
            this.setRoi(roi.getBounds());
        }
    }

    public void setRoi(Polygon polygon) {
        if (polygon == null) {
            this.resetRoi();
            return;
        }
        Rectangle rectangle = polygon.getBounds();
        int n = 0;
        while (n < polygon.npoints) {
            int n2 = n;
            polygon.xpoints[n2] = polygon.xpoints[n2] - rectangle.x;
            int n3 = n++;
            polygon.ypoints[n3] = polygon.ypoints[n3] - rectangle.y;
        }
        PolygonFiller polygonFiller = new PolygonFiller();
        polygonFiller.setPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        ImageProcessor imageProcessor = polygonFiller.getMask(rectangle.width, rectangle.height);
        this.setMask(imageProcessor);
        this.setRoi(rectangle);
        int n4 = 0;
        while (n4 < polygon.npoints) {
            int n5 = n4;
            polygon.xpoints[n5] = polygon.xpoints[n5] + rectangle.x;
            int n6 = n4++;
            polygon.ypoints[n6] = polygon.ypoints[n6] + rectangle.y;
        }
    }

    public void resetRoi() {
        this.roiX = 0;
        this.roiY = 0;
        this.roiWidth = this.width;
        this.roiHeight = this.height;
        this.xMin = 1;
        this.xMax = this.width - 2;
        this.yMin = 1;
        this.yMax = this.height - 2;
        this.mask = null;
        this.clipXMin = 0;
        this.clipXMax = this.width - 1;
        this.clipYMin = 0;
        this.clipYMax = this.height - 1;
    }

    public Rectangle getRoi() {
        return new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
    }

    public void setMask(ImageProcessor imageProcessor) {
        this.mask = imageProcessor;
    }

    public ImageProcessor getMask() {
        return this.mask;
    }

    public byte[] getMaskArray() {
        return this.mask != null ? (byte[])this.mask.getPixels() : null;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
        this.interpolationMethod = bl ? (useBicubic ? 2 : 1) : 0;
    }

    public void setInterpolationMethod(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid interpolation method");
        }
        this.interpolationMethod = n;
        this.interpolate = n != 0;
    }

    public int getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public static String[] getInterpolationMethods() {
        if (interpolationMethods == null) {
            interpolationMethods = new String[]{"None", "Bilinear", "Bicubic"};
        }
        return interpolationMethods;
    }

    public boolean getInterpolate() {
        return this.interpolate;
    }

    public boolean isKillable() {
        return false;
    }

    private void process(int n, double d) {
        double d2 = 255.0 / Math.log(255.0);
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n2;
            switch (n) {
                case 0: {
                    n2 = 255 - i;
                    break;
                }
                case 1: {
                    n2 = this.fgColor;
                    break;
                }
                case 2: {
                    n2 = i + (int)d;
                    break;
                }
                case 3: {
                    n2 = (int)Math.round((double)i * d);
                    break;
                }
                case 4: {
                    n2 = i & (int)d;
                    break;
                }
                case 5: {
                    n2 = i | (int)d;
                    break;
                }
                case 6: {
                    n2 = i ^ (int)d;
                    break;
                }
                case 7: {
                    n2 = (int)(Math.exp(Math.log((double)i / 255.0) * d) * 255.0);
                    break;
                }
                case 8: {
                    if (i == 0) {
                        n2 = 0;
                        break;
                    }
                    n2 = (int)(Math.log(i) * d2);
                    break;
                }
                case 13: {
                    n2 = (int)Math.exp((double)i / d2);
                    break;
                }
                case 11: {
                    n2 = i * i;
                    break;
                }
                case 12: {
                    n2 = (int)Math.sqrt(i);
                    break;
                }
                case 9: {
                    if ((double)i < d) {
                        n2 = (int)d;
                        break;
                    }
                    n2 = i;
                    break;
                }
                case 10: {
                    if ((double)i > d) {
                        n2 = (int)d;
                        break;
                    }
                    n2 = i;
                    break;
                }
                default: {
                    n2 = i;
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[i] = n2;
        }
        this.applyTable(nArray);
    }

    public double[] getLine(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = (int)Math.round(Math.sqrt(d5 * d5 + d6 * d6));
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n;
        double[] dArray = new double[++n];
        double d9 = d;
        double d10 = d2;
        if (this.interpolate) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.getInterpolatedValue(d9, d10);
                d9 += d7;
                d10 += d8;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.getPixelValue((int)(d9 + 0.5), (int)(d10 + 0.5));
                d9 += d7;
                d10 += d8;
            }
        }
        return dArray;
    }

    public void getRow(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.getPixel(n++, n2);
        }
    }

    public void getColumn(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.getPixel(n, n2++);
        }
    }

    public void putRow(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.putPixel(n++, n2, nArray[i]);
        }
    }

    public void putColumn(int n, int n2, int[] nArray, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.putPixel(n, n2++, nArray[i]);
        }
    }

    public void moveTo(int n, int n2) {
        this.cx = n;
        this.cy = n2;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
        if (this.lineWidth < 1) {
            this.lineWidth = 1;
        }
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void lineTo(int n, int n2) {
        int n3 = n - this.cx;
        int n4 = n2 - this.cy;
        int n5 = n3 >= 0 ? n3 : -n3;
        int n6 = n4 >= 0 ? n4 : -n4;
        int n7 = n6 > n5 ? n6 : n5;
        double d = (double)n3 / (double)n7;
        double d2 = (double)n4 / (double)n7;
        double d3 = this.cx;
        double d4 = this.cy;
        this.cx = n;
        this.cy = n2;
        if (++n7 > 1000000) {
            return;
        }
        do {
            if (this.lineWidth == 1) {
                this.drawPixel((int)Math.round(d3), (int)Math.round(d4));
            } else if (this.lineWidth == 2) {
                this.drawDot2((int)Math.round(d3), (int)Math.round(d4));
            } else {
                this.drawDot((int)d3, (int)d4);
            }
            d3 += d;
            d4 += d2;
        } while (--n7 > 0);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.moveTo(n, n2);
        this.lineTo(n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        if (this.lineWidth == 1) {
            this.moveTo(n, n2);
            this.lineTo(n + n3 - 1, n2);
            this.lineTo(n + n3 - 1, n2 + n4 - 1);
            this.lineTo(n, n2 + n4 - 1);
            this.lineTo(n, n2);
        } else {
            this.moveTo(n, n2);
            this.lineTo(n + n3, n2);
            this.lineTo(n + n3, n2 + n4);
            this.lineTo(n, n2 + n4);
            this.lineTo(n, n2);
        }
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if ((long)n3 * (long)n4 > (long)(4 * this.width * this.height)) {
            return;
        }
        OvalRoi ovalRoi = new OvalRoi(n, n2, n3, n4);
        this.drawPolygon(ovalRoi.getPolygon());
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if ((long)n3 * (long)n4 > (long)(4 * this.width * this.height)) {
            return;
        }
        OvalRoi ovalRoi = new OvalRoi(n, n2, n3, n4);
        this.fillPolygon(ovalRoi.getPolygon());
    }

    public void drawPolygon(Polygon polygon) {
        this.moveTo(polygon.xpoints[0], polygon.ypoints[0]);
        for (int i = 0; i < polygon.npoints; ++i) {
            this.lineTo(polygon.xpoints[i], polygon.ypoints[i]);
        }
        this.lineTo(polygon.xpoints[0], polygon.ypoints[0]);
    }

    public void fillPolygon(Polygon polygon) {
        this.setRoi(polygon);
        this.fill(this.getMask());
        this.resetRoi();
    }

    public void drawDot2(int n, int n2) {
        this.drawPixel(n, n2);
        this.drawPixel(n - 1, n2);
        this.drawPixel(n, n2 - 1);
        this.drawPixel(n - 1, n2 - 1);
    }

    public void drawDot(int n, int n2) {
        double d = (double)this.lineWidth / 2.0;
        int n3 = (int)((double)n - d + 0.5);
        int n4 = (int)((double)n2 - d + 0.5);
        int n5 = n3 + this.lineWidth;
        int n6 = n4 + this.lineWidth;
        if (n3 < this.clipXMin || n4 < this.clipYMin || n5 > this.clipXMax || n6 > this.clipYMax) {
            double d2 = d * d;
            double d3 = (double)n3 + (d -= 0.5);
            double d4 = (double)n4 + d;
            for (int i = n4; i < n6; ++i) {
                for (int j = n3; j < n5; ++j) {
                    double d5 = (double)j - d3;
                    double d6 = (double)i - d4;
                    if (!(d5 * d5 + d6 * d6 <= d2)) continue;
                    this.drawPixel(j, i);
                }
            }
        } else {
            if (this.dotMask == null || this.lineWidth != this.dotMask.getWidth()) {
                OvalRoi ovalRoi = new OvalRoi(0, 0, this.lineWidth, this.lineWidth);
                this.dotMask = ovalRoi.getMask();
            }
            this.setRoi(n3, n4, this.lineWidth, this.lineWidth);
            this.fill(this.dotMask);
        }
    }

    private void setupFontMetrics() {
        if (this.fmImage == null) {
            this.fmImage = new BufferedImage(1, 1, 1);
        }
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 12);
        }
        if (this.fontMetrics == null) {
            Graphics graphics = this.fmImage.getGraphics();
            this.fontMetrics = graphics.getFontMetrics(this.font);
        }
    }

    public void drawString(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.setupFontMetrics();
        if (IJ.isMacOSX()) {
            string = string + " ";
        }
        if (string.indexOf("\n") == -1) {
            this.drawString2(string);
        } else {
            String[] stringArray = Tools.split(string, "\n");
            for (int i = 0; i < stringArray.length; ++i) {
                this.drawString2(stringArray[i]);
            }
        }
    }

    private void drawString2(String string) {
        int n = this.getStringWidth(string);
        int n2 = this.cx;
        if (this.justification == 1) {
            n2 -= n / 2;
        } else if (this.justification == 2) {
            n2 -= n;
        }
        int n3 = this.fontMetrics.getHeight();
        if (n <= 0 || n3 <= 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n3, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n4 = fontMetrics.getHeight();
        int n5 = fontMetrics.getDescent();
        graphics.setFont(this.font);
        if (this.antialiasedText && n2 >= 0 && this.cy - n3 >= 0) {
            Java2.setAntialiasedText(graphics, true);
            this.setRoi(n2, this.cy - n3, n, n3);
            ImageProcessor imageProcessor = this.crop();
            this.resetRoi();
            if (imageProcessor.getWidth() == 0 || imageProcessor.getHeight() == 0) {
                return;
            }
            graphics.drawImage(imageProcessor.createImage(), 0, 0, null);
            graphics.setColor(this.drawingColor);
            graphics.drawString(string, 0, n3 - n5);
            graphics.dispose();
            imageProcessor = new ColorProcessor(bufferedImage);
            if (this instanceof ByteProcessor) {
                imageProcessor = imageProcessor.convertToByte(false);
                if (this.isInvertedLut()) {
                    imageProcessor.invert();
                }
            }
            this.insert(imageProcessor, n2, this.cy - n3);
            this.cy += n3;
            return;
        }
        Java2.setAntialiasedText(graphics, false);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n3);
        graphics.setColor(Color.black);
        graphics.drawString(string, 0, n3 - n5);
        graphics.dispose();
        ColorProcessor colorProcessor = new ColorProcessor(bufferedImage);
        ImageProcessor imageProcessor = colorProcessor.convertToByte(false);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        imageProcessor.invert();
        if (n2 < this.width && this.cy - n3 < this.height) {
            this.setMask(imageProcessor);
            this.setRoi(n2, this.cy - n3, n, n3);
            this.fill(this.getMask());
        }
        this.resetRoi();
        this.cy += n3;
    }

    public void drawString(String string, int n, int n2) {
        this.moveTo(n, n2);
        this.drawString(string);
    }

    public void setJustification(int n) {
        this.justification = n;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = null;
        this.boldFont = font.isBold();
    }

    public void setAntialiasedText(boolean bl) {
        this.antialiasedText = bl && (this instanceof ByteProcessor && this.getMin() == 0.0 && this.getMax() == 255.0 || this instanceof ColorProcessor);
    }

    public int getStringWidth(String string) {
        int n;
        this.setupFontMetrics();
        if (this.antialiasedText) {
            Graphics graphics = this.fmImage.getGraphics();
            if (graphics == null) {
                this.fmImage = null;
                this.setupFontMetrics();
                graphics = this.fmImage.getGraphics();
            }
            Java2.setAntialiasedText(graphics, true);
            n = Java2.getStringWidth(string, this.fontMetrics, graphics);
            graphics.dispose();
        } else {
            n = this.fontMetrics.stringWidth(string);
        }
        return n;
    }

    public Font getFont() {
        this.setupFontMetrics();
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        this.setupFontMetrics();
        return this.fontMetrics;
    }

    public void smooth() {
        if (this.width > 1) {
            this.filter(0);
        }
    }

    public void sharpen() {
        if (this.width > 1) {
            int[] nArray = new int[]{-1, -1, -1, -1, 12, -1, -1, -1, -1};
            this.convolve3x3(nArray);
        }
    }

    public void findEdges() {
        if (this.width > 1) {
            this.filter(1);
        }
    }

    public abstract void flipVertical();

    public void flipHorizontal() {
        int[] nArray = new int[this.roiHeight];
        int[] nArray2 = new int[this.roiHeight];
        for (int i = 0; i < this.roiWidth / 2; ++i) {
            this.getColumn(this.roiX + i, this.roiY, nArray, this.roiHeight);
            this.getColumn(this.roiX + this.roiWidth - i - 1, this.roiY, nArray2, this.roiHeight);
            this.putColumn(this.roiX + i, this.roiY, nArray2, this.roiHeight);
            this.putColumn(this.roiX + this.roiWidth - i - 1, this.roiY, nArray, this.roiHeight);
        }
    }

    public ImageProcessor rotateRight() {
        int n = this.height;
        int n2 = this.width;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = new int[this.width];
        for (int i = 0; i < this.height; ++i) {
            this.getRow(0, i, nArray, this.width);
            imageProcessor.putColumn(n - i - 1, 0, nArray, n2);
        }
        return imageProcessor;
    }

    public ImageProcessor rotateLeft() {
        int n = this.height;
        int n2 = this.width;
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        int[] nArray = new int[this.width];
        int[] nArray2 = new int[this.width];
        for (int i = 0; i < this.height; ++i) {
            this.getRow(0, i, nArray, this.width);
            for (int j = 0; j < this.width; ++j) {
                nArray2[j] = nArray[this.width - j - 1];
            }
            imageProcessor.putColumn(i, 0, nArray2, n2);
        }
        return imageProcessor;
    }

    public void insert(ImageProcessor imageProcessor, int n, int n2) {
        this.copyBits(imageProcessor, n, n2, 0);
    }

    public String toString() {
        return "ip[width=" + this.width + ", height=" + this.height + ", min=" + this.getMin() + ", max=" + this.getMax() + "]";
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public abstract void fill(ImageProcessor var1);

    public void fill(Roi roi) {
        ImageProcessor imageProcessor = this.getMask();
        Rectangle rectangle = this.getRoi();
        this.setRoi(roi);
        this.fill(this.getMask());
        this.setMask(imageProcessor);
        this.setRoi(rectangle);
    }

    public void fillOutside(Roi roi) {
        if (roi == null || !roi.isArea()) {
            return;
        }
        ImageProcessor imageProcessor = this.getMask();
        Rectangle rectangle = this.getRoi();
        ShapeRoi shapeRoi = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        ShapeRoi shapeRoi2 = new ShapeRoi(new Roi(0, 0, this.width, this.height));
        this.setRoi(shapeRoi.xor(shapeRoi2));
        this.fill(this.getMask());
        this.setMask(imageProcessor);
        this.setRoi(rectangle);
    }

    public void draw(Roi roi) {
        roi.drawPixels(this);
    }

    public void setCalibrationTable(float[] fArray) {
        this.cTable = fArray;
    }

    public float[] getCalibrationTable() {
        return this.cTable;
    }

    public void setHistogramSize(int n) {
        this.histogramSize = n;
        if (this.histogramSize < 1) {
            this.histogramSize = 1;
        }
    }

    public int getHistogramSize() {
        return this.histogramSize;
    }

    public void setHistogramRange(double d, double d2) {
        if (d > d2) {
            d = 0.0;
            d2 = 0.0;
        }
        this.histogramMin = d;
        this.histogramMax = d2;
    }

    public double getHistogramMin() {
        return this.histogramMin;
    }

    public double getHistogramMax() {
        return this.histogramMax;
    }

    public abstract Object getPixels();

    public abstract Object getPixelsCopy();

    public abstract int getPixel(int var1, int var2);

    public int getPixelCount() {
        return this.width * this.height;
    }

    public abstract int get(int var1, int var2);

    public abstract int get(int var1);

    public abstract void set(int var1, int var2, int var3);

    public abstract void set(int var1, int var2);

    public abstract float getf(int var1, int var2);

    public abstract float getf(int var1);

    public abstract void setf(int var1, int var2, float var3);

    public abstract void setf(int var1, float var2);

    public int[][] getIntArray() {
        int[][] nArray = new int[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                nArray[j][i] = this.get(j, i);
            }
        }
        return nArray;
    }

    public void setIntArray(int[][] nArray) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.set(j, i, nArray[j][i]);
            }
        }
    }

    public float[][] getFloatArray() {
        float[][] fArray = new float[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                fArray[j][i] = this.getf(j, i);
            }
        }
        return fArray;
    }

    public void setFloatArray(float[][] fArray) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.setf(j, i, fArray[j][i]);
            }
        }
    }

    public void getNeighborhood(int n, int n2, double[][] dArray) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = (n3 - 1) / 2;
        int n6 = (n4 - 1) / 2;
        if (n >= n5 && n2 >= n6 && n < this.width - n5 - 1 && n2 < this.height - n6 - 1) {
            int n7 = (n2 - n6) * this.width + (n - n5);
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[j][i] = this.getf(n7++);
                }
                n7 += this.width - n3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[j][i] = this.getPixelValue(j, i);
                }
            }
        }
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{this.getPixel(n, n2)};
        }
        return nArray;
    }

    public void putPixel(int n, int n2, int[] nArray) {
        this.putPixel(n, n2, nArray[0]);
    }

    public abstract double getInterpolatedPixel(double var1, double var3);

    public abstract int getPixelInterpolated(double var1, double var3);

    public final double getInterpolatedValue(double d, double d2) {
        if (useBicubic) {
            return this.getBicubicInterpolatedPixel(d, d2, this);
        }
        if (d < 0.0 || d >= (double)this.width - 1.0 || d2 < 0.0 || d2 >= (double)this.height - 1.0) {
            if (d < -1.0 || d >= (double)this.width || d2 < -1.0 || d2 >= (double)this.height) {
                return 0.0;
            }
            return this.getInterpolatedEdgeValue(d, d2);
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        double d5 = this.getPixelValue(n, n2);
        double d6 = this.getPixelValue(n + 1, n2);
        double d7 = this.getPixelValue(n + 1, n2 + 1);
        double d8 = this.getPixelValue(n, n2 + 1);
        double d9 = d8 + d3 * (d7 - d8);
        double d10 = d5 + d3 * (d6 - d5);
        return d10 + d4 * (d9 - d10);
    }

    public double getBicubicInterpolatedPixel(double d, double d2, ImageProcessor imageProcessor) {
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        if (n <= 0 || n >= this.width - 2 || n2 <= 0 || n2 >= this.height - 2) {
            return imageProcessor.getBilinearInterpolatedPixel(d, d2);
        }
        double d3 = 0.0;
        for (int i = 0; i <= 3; ++i) {
            int n3 = n2 - 1 + i;
            double d4 = 0.0;
            for (int j = 0; j <= 3; ++j) {
                int n4 = n - 1 + j;
                d4 += (double)imageProcessor.get(n4, n3) * ImageProcessor.cubic(d - (double)n4);
            }
            d3 += d4 * ImageProcessor.cubic(d2 - (double)n3);
        }
        return d3;
    }

    final double getBilinearInterpolatedPixel(double d, double d2) {
        if (d >= -1.0 && d < (double)this.width && d2 >= -1.0 && d2 < (double)this.height) {
            int n = this.interpolationMethod;
            this.interpolationMethod = 1;
            double d3 = this.getInterpolatedPixel(d, d2);
            this.interpolationMethod = n;
            return d3;
        }
        return this.getBackgroundValue();
    }

    public static final double cubic(double d) {
        if (d < 0.0) {
            d = -d;
        }
        double d2 = 0.0;
        if (d < 1.0) {
            d2 = d * d * (d * 1.5 + -2.5) + 1.0;
        } else if (d < 2.0) {
            d2 = -0.5 * d * d * d + 2.5 * d * d - 4.0 * d + 2.0;
        }
        return d2;
    }

    private final double getInterpolatedEdgeValue(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        double d5 = this.getEdgeValue(n, n2);
        double d6 = this.getEdgeValue(n + 1, n2);
        double d7 = this.getEdgeValue(n + 1, n2 + 1);
        double d8 = this.getEdgeValue(n, n2 + 1);
        double d9 = d8 + d3 * (d7 - d8);
        double d10 = d5 + d3 * (d6 - d5);
        return d10 + d4 * (d9 - d10);
    }

    private float getEdgeValue(int n, int n2) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        return this.getPixelValue(n, n2);
    }

    public abstract void putPixel(int var1, int var2, int var3);

    public abstract float getPixelValue(int var1, int var2);

    public abstract void putPixelValue(int var1, int var2, double var3);

    public abstract void drawPixel(int var1, int var2);

    public abstract void setPixels(Object var1);

    public abstract void copyBits(ImageProcessor var1, int var2, int var3, int var4);

    public abstract void applyTable(int[] var1);

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int n) {
        this.process(2, n);
    }

    public void add(double d) {
        this.process(2, d);
    }

    public void multiply(double d) {
        this.process(3, d);
    }

    public void and(int n) {
        this.process(4, n);
    }

    public void or(int n) {
        this.process(5, n);
    }

    public void xor(int n) {
        this.process(6, n);
    }

    public void gamma(double d) {
        this.process(7, d);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void exp() {
        this.process(13, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void abs() {
    }

    public void min(double d) {
        this.process(9, d);
    }

    public void max(double d) {
        this.process(10, d);
    }

    public abstract Image createImage();

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.createImage(), 0, 0, null);
        return bufferedImage;
    }

    public abstract ImageProcessor createProcessor(int var1, int var2);

    public abstract void snapshot();

    public abstract void reset();

    public abstract void reset(ImageProcessor var1);

    public abstract void setSnapshotPixels(Object var1);

    public abstract Object getSnapshotPixels();

    public abstract void convolve3x3(int[] var1);

    public abstract void filter(int var1);

    public abstract void medianFilter();

    public abstract void noise(double var1);

    public abstract ImageProcessor crop();

    public abstract void threshold(int var1);

    public abstract ImageProcessor duplicate();

    public abstract void scale(double var1, double var3);

    public abstract ImageProcessor resize(int var1, int var2);

    public ImageProcessor resize(int n) {
        return this.resize(n, (int)((double)n * ((double)this.roiHeight / (double)this.roiWidth)));
    }

    public ImageProcessor resize(int n, int n2, boolean bl) {
        Rectangle rectangle = this.getRoi();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n >= n3 && n2 >= n4 || !bl) {
            return this.resize(n, n2);
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        FloatProcessor floatProcessor = null;
        for (int i = 0; i < this.getNChannels(); ++i) {
            floatProcessor = this.toFloat(i, floatProcessor);
            floatProcessor.setInterpolationMethod(this.interpolationMethod);
            floatProcessor.setRoi(this.getRoi());
            FloatProcessor floatProcessor2 = floatProcessor.downsize(n, n2);
            imageProcessor.setPixels(i, floatProcessor2);
        }
        return imageProcessor;
    }

    public abstract void rotate(double var1);

    public void translate(double d, double d2) {
        boolean bl;
        ImageProcessor imageProcessor = this.duplicate();
        boolean bl2 = bl = d == (double)((int)d) && d2 == (double)((int)d2);
        if (bl || this.interpolationMethod == 0) {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                    this.putPixel(j, i, imageProcessor.getPixel(j - (int)d, i - (int)d2));
                }
            }
        } else if (this.interpolationMethod == 2 && this instanceof ColorProcessor) {
            ((ColorProcessor)this).filterRGB(9, d, d2);
        } else {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                if (i % 30 == 0) {
                    this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
                }
                for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                    this.putPixel(j, i, imageProcessor.getPixelInterpolated((double)j - d, (double)i - d2));
                }
            }
            this.showProgress(1.0);
        }
    }

    public void translate(int n, int n2, boolean bl) {
        this.translate(n, n2);
    }

    public abstract int[] getHistogram();

    public abstract void erode();

    public abstract void dilate();

    public void setLutAnimation(boolean bl) {
        this.lutAnimation = bl;
        this.newPixels = true;
        this.source = null;
    }

    void resetPixels(Object object) {
        if (object == null) {
            if (this.img != null) {
                this.img.flush();
                this.img = null;
            }
            this.source = null;
        }
        this.newPixels = true;
        this.source = null;
    }

    public ImageProcessor convertToByte(boolean bl) {
        TypeConverter typeConverter = new TypeConverter(this, bl);
        return typeConverter.convertToByte();
    }

    public ImageProcessor convertToShort(boolean bl) {
        TypeConverter typeConverter = new TypeConverter(this, bl);
        return typeConverter.convertToShort();
    }

    public ImageProcessor convertToFloat() {
        TypeConverter typeConverter = new TypeConverter(this, false);
        return typeConverter.convertToFloat(this.cTable);
    }

    public ImageProcessor convertToRGB() {
        TypeConverter typeConverter = new TypeConverter(this, true);
        return typeConverter.convertToRGB();
    }

    public abstract void convolve(float[] var1, int var2, int var3);

    public void autoThreshold() {
        this.threshold(this.getAutoThreshold());
    }

    public int getAutoThreshold() {
        return this.getAutoThreshold(this.getHistogram());
    }

    public int getAutoThreshold(int[] nArray) {
        double d;
        int n;
        int n2;
        int n3 = nArray.length - 1;
        int n4 = nArray[0];
        nArray[0] = 0;
        int n5 = nArray[n3];
        nArray[n3] = 0;
        for (n2 = 0; nArray[n2] == 0 && n2 < n3; ++n2) {
        }
        for (n = n3; nArray[n] == 0 && n > 0; --n) {
        }
        if (n2 >= n) {
            nArray[0] = n4;
            nArray[n3] = n5;
            int n6 = nArray.length / 2;
            return n6;
        }
        int n7 = n2;
        int n8 = Math.max(n / 40, 1);
        do {
            int n9;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (n9 = n2; n9 <= n7; ++n9) {
                d5 += (double)n9 * (double)nArray[n9];
                d4 += (double)nArray[n9];
            }
            for (n9 = n7 + 1; n9 <= n; ++n9) {
                d3 += (double)n9 * (double)nArray[n9];
                d2 += (double)nArray[n9];
            }
            d = (d5 / d4 + d3 / d2) / 2.0;
            if (n <= 255 || ++n7 % n8 != 0) continue;
            this.showProgress((double)n7 / (double)n);
        } while ((double)(n7 + 1) <= d && n7 < n - 1);
        this.showProgress(1.0);
        nArray[0] = n4;
        nArray[n3] = n5;
        int n10 = (int)Math.round(d);
        return n10;
    }

    public void setClipRect(Rectangle rectangle) {
        if (rectangle == null) {
            this.clipXMin = 0;
            this.clipXMax = this.width - 1;
            this.clipYMin = 0;
            this.clipYMax = this.height - 1;
        } else {
            this.clipXMin = rectangle.x;
            this.clipXMax = rectangle.x + rectangle.width - 1;
            this.clipYMin = rectangle.y;
            this.clipYMax = rectangle.y + rectangle.height - 1;
            if (this.clipXMin < 0) {
                this.clipXMin = 0;
            }
            if (this.clipXMax >= this.width) {
                this.clipXMax = this.width - 1;
            }
            if (this.clipYMin < 0) {
                this.clipYMin = 0;
            }
            if (this.clipYMax >= this.height) {
                this.clipYMax = this.height - 1;
            }
        }
    }

    protected String maskSizeError(ImageProcessor imageProcessor) {
        return "Mask size (" + imageProcessor.getWidth() + "x" + imageProcessor.getHeight() + ") != ROI size (" + this.roiWidth + "x" + this.roiHeight + ")";
    }

    protected SampleModel getIndexSampleModel() {
        if (this.sampleModel == null) {
            IndexColorModel indexColorModel = this.getDefaultColorModel();
            WritableRaster writableRaster = indexColorModel.createCompatibleWritableRaster(1, 1);
            this.sampleModel = writableRaster.getSampleModel();
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.width, this.height);
        }
        return this.sampleModel;
    }

    public IndexColorModel getDefaultColorModel() {
        if (defaultColorModel == null) {
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
                byArray2[i] = (byte)i;
                byArray3[i] = (byte)i;
            }
            defaultColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        return defaultColorModel;
    }

    public void setSnapshotCopyMode(boolean bl) {
        this.snapshotCopyMode = bl;
    }

    public int getNChannels() {
        return 1;
    }

    public abstract FloatProcessor toFloat(int var1, FloatProcessor var2);

    public abstract void setPixels(int var1, FloatProcessor var2);

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 255.0;
    }

    public void updateComposite(int[] nArray, int n) {
        int n2 = this.width * this.height;
        if (this.bytes == null || !this.lutAnimation) {
            this.bytes = this.create8BitImage();
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.reds == null || this.cm != this.cm2) {
            this.updateLutBytes();
        }
        switch (n) {
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray[i] & 0xFF00FFFF | this.reds[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray[i] & 0xFFFF00FF | this.greens[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray[i] & 0xFFFFFF00 | this.blues[this.bytes[i] & 0xFF];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.reds[this.bytes[i] & 0xFF];
                    int n4 = this.greens[this.bytes[i] & 0xFF];
                    int n5 = this.blues[this.bytes[i] & 0xFF];
                    nArray[i] = n3 | n4 | n5;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n2; ++i) {
                    int n6 = nArray[i];
                    int n7 = (n6 & 0xFF0000) + this.reds[this.bytes[i] & 0xFF];
                    int n8 = (n6 & 0xFF00) + this.greens[this.bytes[i] & 0xFF];
                    int n9 = (n6 & 0xFF) + this.blues[this.bytes[i] & 0xFF];
                    if (n7 > 0xFF0000) {
                        n7 = 0xFF0000;
                    }
                    if (n8 > 65280) {
                        n8 = 65280;
                    }
                    if (n9 > 255) {
                        n9 = 255;
                    }
                    nArray[i] = n7 | n8 | n9;
                }
                break;
            }
        }
        this.lutAnimation = false;
    }

    byte[] create8BitImage() {
        return null;
    }

    void updateLutBytes() {
        int n;
        IndexColorModel indexColorModel = (IndexColorModel)this.cm;
        int n2 = indexColorModel.getMapSize();
        if (this.reds == null || this.reds.length != n2) {
            this.reds = new int[n2];
            this.greens = new int[n2];
            this.blues = new int[n2];
        }
        byte[] byArray = new byte[n2];
        indexColorModel.getReds(byArray);
        for (n = 0; n < n2; ++n) {
            this.reds[n] = (byArray[n] & 0xFF) << 16;
        }
        indexColorModel.getGreens(byArray);
        for (n = 0; n < n2; ++n) {
            this.greens[n] = (byArray[n] & 0xFF) << 8;
        }
        indexColorModel.getBlues(byArray);
        for (n = 0; n < n2; ++n) {
            this.blues[n] = byArray[n] & 0xFF;
        }
        this.cm2 = this.cm;
    }

    public static void setOverColor(int n, int n2, int n3) {
        overRed = n;
        overGreen = n2;
        overBlue = n3;
    }

    public static void setUnderColor(int n, int n2, int n3) {
        underRed = n;
        underGreen = n2;
        underBlue = n3;
    }

    public boolean isBinary() {
        return false;
    }

    public static void setUseBicubic(boolean bl) {
        useBicubic = bl;
    }

    public ImageStatistics getStatistics() {
        return ImageStatistics.getStatistics(this, 127, null);
    }

    public int getSliceNumber() {
        if (this.sliceNumber < 1) {
            return 1;
        }
        return this.sliceNumber;
    }

    public void setSliceNumber(int n) {
        this.sliceNumber = n;
    }

    static {
        overGreen = 255;
        underBlue = 255;
    }
}

