/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ColorThresholder
extends PlugInFrame
implements PlugIn,
Measurements,
ActionListener,
AdjustmentListener,
FocusListener,
ItemListener,
Runnable {
    private static final int HSB = 0;
    private static final int RGB = 1;
    private static final int LAB = 2;
    private static final int YUV = 3;
    private static final String[] colorSpaces = new String[]{"HSB", "RGB", "Lab", "YUV"};
    private boolean flag = false;
    private int colorSpace = 0;
    private Thread thread;
    private static Frame instance;
    private BandPlot plot = new BandPlot();
    private BandPlot splot = new BandPlot();
    private BandPlot bplot = new BandPlot();
    private int sliderRange = 256;
    private Panel panel;
    private Panel panelt;
    private Button originalB;
    private Button filteredB;
    private Button stackB;
    private Button helpB;
    private Button sampleB;
    private Button resetallB;
    private Button newB;
    private Button macroB;
    private Button selectB;
    private Checkbox bandPassH;
    private Checkbox bandPassS;
    private Checkbox bandPassB;
    private Checkbox darkBackground;
    private CheckboxGroup colourMode;
    private Choice colorSpaceChoice;
    private Choice methodChoice;
    private Choice modeChoice;
    private int previousImageID = -1;
    private int previousSlice = -1;
    private ImageJ ij;
    private int minHue = 0;
    private int minSat = 0;
    private int minBri = 0;
    private int maxHue = 255;
    private int maxSat = 255;
    private int maxBri = 255;
    private Scrollbar minSlider;
    private Scrollbar maxSlider;
    private Scrollbar minSlider2;
    private Scrollbar maxSlider2;
    private Scrollbar minSlider3;
    private Scrollbar maxSlider3;
    private Label label1;
    private Label label2;
    private Label label3;
    private Label label4;
    private Label label5;
    private Label label6;
    private Label labelh;
    private Label labels;
    private Label labelb;
    private Label labelf;
    private boolean done;
    private byte[] hSource;
    private byte[] sSource;
    private byte[] bSource;
    private boolean applyingStack;
    private static final int DEFAULT = 0;
    private static String[] methodNames;
    private static String method;
    private static AutoThresholder thresholder;
    private static final int RED = 0;
    private static final int WHITE = 1;
    private static final int BLACK = 2;
    private static final int BLACK_AND_WHITE = 3;
    private static final String[] modes;
    private static int mode;
    private int numSlices;
    private ImageStack stack;
    private int width;
    private int height;
    private int numPixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorThresholder() {
        super("Threshold Color (experimental)");
        int n;
        if (instance != null) {
            instance.toFront();
            return;
        }
        this.thread = new Thread((Runnable)this, "BandAdjuster");
        WindowManager.addWindow(this);
        instance = this;
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.labelh = new Label("Hue", 1);
        this.add((Component)this.labelh, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.labelf = new Label("", 2);
        this.add((Component)this.labelf, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.plot, gridBagConstraints);
        this.bandPassH = new Checkbox("Pass");
        this.bandPassH.addItemListener(this);
        this.bandPassH.setState(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassH, gridBagConstraints);
        this.minSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider, gridBagConstraints);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label1 = new Label("       ", 0);
        this.label1.setFont(font);
        this.add((Component)this.label1, gridBagConstraints);
        this.maxSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider, gridBagConstraints);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label2 = new Label("       ", 0);
        this.label2.setFont(font);
        this.add((Component)this.label2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.labels = new Label("Saturation", 1);
        this.add((Component)this.labels, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.splot, gridBagConstraints);
        this.bandPassS = new Checkbox("Pass");
        this.bandPassS.addItemListener(this);
        this.bandPassS.setState(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassS, gridBagConstraints);
        this.minSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider2, gridBagConstraints);
        this.minSlider2.addAdjustmentListener(this);
        this.minSlider2.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label3 = new Label("       ", 0);
        this.label3.setFont(font);
        this.add((Component)this.label3, gridBagConstraints);
        this.maxSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider2, gridBagConstraints);
        this.maxSlider2.addAdjustmentListener(this);
        this.maxSlider2.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label4 = new Label("       ", 0);
        this.label4.setFont(font);
        this.add((Component)this.label4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.labelb = new Label("Brightness", 1);
        this.add((Component)this.labelb, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bplot, gridBagConstraints);
        this.bandPassB = new Checkbox("Pass");
        this.bandPassB.addItemListener(this);
        this.bandPassB.setState(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassB, gridBagConstraints);
        this.minSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider3, gridBagConstraints);
        this.minSlider3.addAdjustmentListener(this);
        this.minSlider3.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label5 = new Label("       ", 0);
        this.label5.setFont(font);
        this.add((Component)this.label5, gridBagConstraints);
        this.maxSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider3, gridBagConstraints);
        this.maxSlider3.addAdjustmentListener(this);
        this.maxSlider3.setUnitIncrement(1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.label6 = new Label("       ", 0);
        this.label6.setFont(font);
        this.add((Component)this.label6, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        int n3 = 0;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = n3;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        Label label = new Label("Thresholding method:");
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        panel.add(label);
        this.methodChoice = new Choice();
        for (n = 0; n < methodNames.length; n += 1) {
            this.methodChoice.addItem(methodNames[n]);
        }
        this.methodChoice.select(method);
        this.methodChoice.addItemListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = n3++;
        gridBagConstraints2.anchor = 17;
        gridBagLayout2.setConstraints(this.methodChoice, gridBagConstraints2);
        panel.add(this.methodChoice);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = n3;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        label = new Label("Threshold color:");
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        panel.add(label);
        this.modeChoice = new Choice();
        for (n = 0; n < modes.length; n += 1) {
            this.modeChoice.addItem(modes[n]);
        }
        this.modeChoice.select(mode);
        this.modeChoice.addItemListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = n3++;
        gridBagConstraints2.anchor = 17;
        gridBagLayout2.setConstraints(this.modeChoice, gridBagConstraints2);
        panel.add(this.modeChoice);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = n3;
        gridBagConstraints2.anchor = 13;
        label = new Label("Color space:");
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        panel.add(label);
        this.colorSpaceChoice = new Choice();
        for (n = 0; n < colorSpaces.length; n += 1) {
            this.colorSpaceChoice.addItem(colorSpaces[n]);
        }
        this.colorSpaceChoice.select(0);
        this.colorSpaceChoice.addItemListener(this);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = n3++;
        gridBagConstraints2.anchor = 17;
        gridBagLayout2.setConstraints(this.colorSpaceChoice, gridBagConstraints2);
        panel.add(this.colorSpaceChoice);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)panel, gridBagConstraints);
        this.panelt = new Panel();
        n = Prefs.get("cthresholder.dark", true) ? 1 : 0;
        this.darkBackground = new Checkbox("Dark background", n != 0);
        this.darkBackground.addItemListener(this);
        this.panelt.add(this.darkBackground);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.panelt, gridBagConstraints);
        int n4 = IJ.isMacOSX() ? 10 : 0;
        panel = new Panel();
        panel.setLayout(new GridLayout(0, 4, 0, 0));
        this.originalB = new TrimmedButton("Original", n4);
        this.originalB.addActionListener(this);
        this.originalB.addKeyListener(this.ij);
        panel.add(this.originalB);
        this.filteredB = new TrimmedButton("Filtered", n4);
        this.filteredB.setEnabled(false);
        this.filteredB.addActionListener(this);
        this.filteredB.addKeyListener(this.ij);
        panel.add(this.filteredB);
        this.selectB = new TrimmedButton("Select", n4);
        this.selectB.addActionListener(this);
        this.selectB.addKeyListener(this.ij);
        panel.add(this.selectB);
        this.sampleB = new TrimmedButton("Sample", n4);
        this.sampleB.addActionListener(this);
        this.sampleB.addKeyListener(this.ij);
        panel.add(this.sampleB);
        this.stackB = new TrimmedButton("Stack", n4);
        this.stackB.addActionListener(this);
        this.stackB.addKeyListener(this.ij);
        panel.add(this.stackB);
        this.macroB = new TrimmedButton("Macro", n4);
        this.macroB.addActionListener(this);
        this.macroB.addKeyListener(this.ij);
        panel.add(this.macroB);
        this.helpB = new TrimmedButton("Help", n4);
        this.helpB.addActionListener(this);
        this.helpB.addKeyListener(this.ij);
        panel.add(this.helpB);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.setVisible(true);
        this.thread.start();
        if (!this.checkImage()) {
            return;
        }
        ColorThresholder colorThresholder = this;
        synchronized (colorThresholder) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ColorThresholder colorThresholder = this;
            synchronized (colorThresholder) {
                ImagePlus imagePlus;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.done && (imagePlus = WindowManager.getCurrentImage()) != null) {
                    this.reset(imagePlus);
                    this.apply(imagePlus);
                    imagePlus.updateAndDraw();
                }
            }
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.adjustmentValueChanged ");
        }
        if (!this.checkImage()) {
            return;
        }
        if (adjustmentEvent.getSource() == this.minSlider) {
            this.adjustMinHue(this.minSlider.getValue());
        } else if (adjustmentEvent.getSource() == this.maxSlider) {
            this.adjustMaxHue(this.maxSlider.getValue());
        } else if (adjustmentEvent.getSource() == this.minSlider2) {
            this.adjustMinSat(this.minSlider2.getValue());
        } else if (adjustmentEvent.getSource() == this.maxSlider2) {
            this.adjustMaxSat(this.maxSlider2.getValue());
        } else if (adjustmentEvent.getSource() == this.minSlider3) {
            this.adjustMinBri(this.minSlider3.getValue());
        } else if (adjustmentEvent.getSource() == this.maxSlider3) {
            this.adjustMaxBri(this.maxSlider3.getValue());
        }
        this.updateLabels();
        this.updatePlot();
        this.notify();
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        ImagePlus imagePlus;
        if (IJ.debugMode) {
            IJ.log("ColorThresolder.itemStateChanged");
        }
        if ((imagePlus = WindowManager.getCurrentImage()) == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.methodChoice) {
            method = this.methodChoice.getSelectedItem();
        } else if (object == this.modeChoice) {
            mode = this.modeChoice.getSelectedIndex();
        } else if (object == this.colorSpaceChoice) {
            this.colorSpace = ((Choice)object).getSelectedIndex();
            this.flag = true;
            this.filteredB.setEnabled(false);
            this.minBri = 0;
            this.minSat = 0;
            this.minHue = 0;
            this.maxBri = 255;
            this.maxSat = 255;
            this.maxHue = 255;
            this.bandPassH.setState(true);
            this.bandPassS.setState(true);
            this.bandPassB.setState(true);
        } else if (object == this.darkBackground) {
            // empty if block
        }
        this.reset(imagePlus);
        if (object == this.methodChoice || object == this.colorSpaceChoice || object == this.darkBackground) {
            this.autoSetThreshold();
        }
        this.checkImage();
        this.updateNames();
        this.notify();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (IJ.debugMode) {
            IJ.log("ColorThresolder.focusGained");
        }
        this.checkImage();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.actionPerformed");
        }
        if ((button = (Button)actionEvent.getSource()) == null) {
            return;
        }
        boolean bl = this.checkImage();
        if (bl) {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus == null) {
                return;
            }
            if (button == this.originalB) {
                this.reset(imagePlus);
                imagePlus.setProperty("OriginalImage", null);
                this.filteredB.setEnabled(true);
            } else if (button == this.filteredB) {
                this.reset(imagePlus);
                this.apply(imagePlus);
            } else if (button == this.sampleB) {
                this.reset(imagePlus);
                this.sample();
                this.apply(imagePlus);
            } else if (button == this.selectB) {
                this.createSelection();
            } else if (button == this.stackB) {
                this.applyStack();
            } else {
                if (button == this.macroB) {
                    this.generateMacro();
                    return;
                }
                if (button == this.helpB) {
                    this.showHelp();
                    return;
                }
            }
            this.updatePlot();
            this.updateLabels();
            imagePlus.updateAndDraw();
        } else {
            IJ.beep();
            IJ.showStatus("No Image");
        }
    }

    void createSelection() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        imagePlus.killRoi();
        mode = 3;
        this.apply(imagePlus);
        IJ.run(imagePlus, "8-bit", "");
        IJ.run(imagePlus, "Create Selection", "");
        IJ.run(imagePlus, "RGB Color", "");
        this.reset(imagePlus);
    }

    void generateMacro() {
        if (!Recorder.record) {
            IJ.error("Threshold Color", "Command recorder is not running");
            return;
        }
        Recorder.recordString("// Color Thresholder " + IJ.getVersion() + "\n");
        Recorder.recordString("// Autogenerated macro, single images only!\n");
        Recorder.recordString("min=newArray(3);\n");
        Recorder.recordString("max=newArray(3);\n");
        Recorder.recordString("filter=newArray(3);\n");
        Recorder.recordString("a=getTitle();\n");
        if (this.colorSpace == 0) {
            Recorder.recordString("run(\"HSB Stack\");\n");
            Recorder.recordString("run(\"Convert Stack to Images\");\n");
            Recorder.recordString("selectWindow(\"Hue\");\n");
            Recorder.recordString("rename(\"0\");\n");
            Recorder.recordString("selectWindow(\"Saturation\");\n");
            Recorder.recordString("rename(\"1\");\n");
            Recorder.recordString("selectWindow(\"Brightness\");\n");
            Recorder.recordString("rename(\"2\");\n");
        } else {
            if (this.colorSpace == 2) {
                Recorder.recordString("call(\"ij.plugin.frame.ColorThresholder.RGBtoLab\");\n");
            }
            if (this.colorSpace == 3) {
                Recorder.recordString("call(\"ij.plugin.frame.ColorThresholder.RGBtoYUV\");\n");
            }
            Recorder.recordString("run(\"RGB Stack\");\n");
            Recorder.recordString("run(\"Convert Stack to Images\");\n");
            Recorder.recordString("selectWindow(\"Red\");\n");
            Recorder.recordString("rename(\"0\");\n");
            Recorder.recordString("selectWindow(\"Green\");\n");
            Recorder.recordString("rename(\"1\");\n");
            Recorder.recordString("selectWindow(\"Blue\");\n");
            Recorder.recordString("rename(\"2\");\n");
        }
        Recorder.recordString("min[0]=" + this.minSlider.getValue() + ";\n");
        Recorder.recordString("max[0]=" + this.maxSlider.getValue() + ";\n");
        if (this.bandPassH.getState()) {
            Recorder.recordString("filter[0]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[0]=\"stop\";\n");
        }
        Recorder.recordString("min[1]=" + this.minSlider2.getValue() + ";\n");
        Recorder.recordString("max[1]=" + this.maxSlider2.getValue() + ";\n");
        if (this.bandPassS.getState()) {
            Recorder.recordString("filter[1]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[1]=\"stop\";\n");
        }
        Recorder.recordString("min[2]=" + this.minSlider3.getValue() + ";\n");
        Recorder.recordString("max[2]=" + this.maxSlider3.getValue() + ";\n");
        if (this.bandPassB.getState()) {
            Recorder.recordString("filter[2]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[2]=\"stop\";\n");
        }
        Recorder.recordString("for (i=0;i<3;i++){\n");
        Recorder.recordString("  selectWindow(\"\"+i);\n");
        Recorder.recordString("  setThreshold(min[i], max[i]);\n");
        Recorder.recordString("  run(\"Convert to Mask\");\n");
        Recorder.recordString("  if (filter[i]==\"stop\")  run(\"Invert\");\n");
        Recorder.recordString("}\n");
        Recorder.recordString("imageCalculator(\"AND create\", \"0\",\"1\");\n");
        Recorder.recordString("imageCalculator(\"AND create\", \"Result of 0\",\"2\");\n");
        Recorder.recordString("for (i=0;i<3;i++){\n");
        Recorder.recordString("  selectWindow(\"\"+i);\n");
        Recorder.recordString("  close();\n");
        Recorder.recordString("}\n");
        Recorder.recordString("selectWindow(\"Result of 0\");\n");
        Recorder.recordString("close();\n");
        Recorder.recordString("selectWindow(\"Result of Result of 0\");\n");
        Recorder.recordString("rename(a);\n");
        Recorder.recordString("// Colour Thresholding-------------\n");
    }

    void showHelp() {
        IJ.showMessage("Help", "Color Thresholder\n \nModification of Bob Dougherty's BandPass2 plugin by G.Landini\nto threshold 24 bit RGB images based on HSB, RGB, CIE Lab \nor YUV components.\n \n[Pass]: Everything within range is thresholded, otherwise,\neverything outside range is thresholded.\n \n[Default] [Huang] [Intermodes] [etc.]: Selects the automatic\nthresholding method.\n \n[Red] [White] [Black] [B&W]: Selects the threshold color.\n \n[Dark background]: Auto-thresholding methods assume\nlight features and dark background.\n \n[Original]: Shows the original image and updates the buffer\nwhen switching to another image.\n \n[Filtered]: Shows the filtered image.\n \n[Stack]: Processes the rest of the slices in the stack (if any)\nusing the current settings.\n \n[Macro]: Creates a macro based on the current settings which\nis sent to the macro Recorder window, if open.\n \n[Sample]: (experimental) Sets the ranges of the filters based\non the pixel value components in a user-defined ROI.\n \n[HSB] [RGB] [CIE Lab] [YUV]: Selects the color space.\n \n");
    }

    void sample() {
        int n;
        int n2;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        int[] nArray = new int[256];
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        boolean bl3 = false;
        int n6 = 0;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            IJ.error("Selection required");
            return;
        }
        ImageProcessor imageProcessor = roi.getMask();
        Rectangle rectangle = roi.getBoundingRect();
        ImageProcessor imageProcessor2 = imagePlus.getProcessor();
        if (imageProcessor == null) {
            n6 = rectangle.width * rectangle.height;
        } else {
            n6 = 0;
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    if (imageProcessor.getPixel(n, n2) == 0) continue;
                    ++n6;
                }
            }
        }
        byte[] byArray = new byte[n6];
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n6];
        int[] nArray2 = new int[n6];
        if (imageProcessor == null) {
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    nArray2[n3++] = imageProcessor2.getPixel(n + rectangle.x, n2 + rectangle.y);
                }
            }
        } else {
            for (n2 = 0; n2 < rectangle.height; ++n2) {
                for (n = 0; n < rectangle.width; ++n) {
                    if (imageProcessor.getPixel(n, n2) == 0) continue;
                    nArray2[n3++] = imageProcessor2.getPixel(n + rectangle.x, n2 + rectangle.y);
                }
            }
        }
        imagePlus.killRoi();
        ColorProcessor colorProcessor = new ColorProcessor(1, n6, nArray2);
        int n7 = 256;
        int n8 = -1;
        int n9 = 256;
        int n10 = -1;
        int n11 = 256;
        int n12 = -1;
        int n13 = 256;
        int n14 = -1;
        int n15 = 256;
        int n16 = -1;
        int n17 = 256;
        int n18 = -1;
        if (this.colorSpace == 1) {
            colorProcessor.getRGB(byArray, byArray2, byArray3);
        } else if (this.colorSpace == 0) {
            colorProcessor.getHSB(byArray, byArray2, byArray3);
        } else if (this.colorSpace == 2) {
            this.getLab(colorProcessor, byArray, byArray2, byArray3);
        } else if (this.colorSpace == 3) {
            this.getYUV(colorProcessor, byArray, byArray2, byArray3);
        }
        for (n = 0; n < n6; ++n) {
            nArray[byArray[n] & 0xFF] = 1;
            if ((byArray[n] & 0xFF) > n8) {
                n8 = byArray[n] & 0xFF;
            }
            if ((byArray[n] & 0xFF) < n7) {
                n7 = byArray[n] & 0xFF;
            }
            if ((byArray2[n] & 0xFF) > n10) {
                n10 = byArray2[n] & 0xFF;
            }
            if ((byArray2[n] & 0xFF) < n9) {
                n9 = byArray2[n] & 0xFF;
            }
            if ((byArray3[n] & 0xFF) > n12) {
                n12 = byArray3[n] & 0xFF;
            }
            if ((byArray3[n] & 0xFF) >= n11) continue;
            n11 = byArray3[n] & 0xFF;
        }
        if (this.colorSpace == 0) {
            int n19 = 0;
            int n20 = 0;
            int n21 = -1;
            int n22 = -1;
            int n23 = 0;
            if (nArray[0] == 0) {
                n23 = 0;
                n19 = 1;
            }
            for (n = 1; n < 256; ++n) {
                if (nArray[n] != 0) continue;
                if (nArray[n - 1] > 0) {
                    n19 = 1;
                    n23 = n;
                } else {
                    ++n19;
                }
                if (n19 <= n20) continue;
                n20 = n19;
                n21 = n23;
                n22 = n;
            }
            for (n = 0; n < 256; ++n) {
                if (nArray[n] <= 0) continue;
                n5 = n;
                break;
            }
            for (n = 255; n >= 0; --n) {
                if (nArray[n] <= 0) continue;
                n4 = n;
                break;
            }
            if (n4 - n5 < n20) {
                this.bandPassH.setState(true);
                n7 = n5;
                n8 = n4;
            } else {
                this.bandPassH.setState(false);
                n7 = n21;
                n8 = n22;
            }
        } else {
            this.bandPassH.setState(true);
        }
        this.adjustMinHue(n7);
        this.minSlider.setValue(n7);
        this.adjustMaxHue(n8);
        this.maxSlider.setValue(n8);
        this.adjustMinSat(n9);
        this.minSlider2.setValue(n9);
        this.adjustMaxSat(n10);
        this.maxSlider2.setValue(n10);
        this.adjustMinBri(n11);
        this.minSlider3.setValue(n11);
        this.adjustMaxBri(n12);
        this.maxSlider3.setValue(n12);
    }

    private boolean checkImage() {
        ImagePlus imagePlus;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.checkImage");
        }
        if ((imagePlus = WindowManager.getCurrentImage()) == null || imagePlus.getBitDepth() != 24) {
            IJ.beep();
            IJ.showStatus("No RGB image");
            return false;
        }
        imagePlus.killRoi();
        boolean bl = this.setup(imagePlus);
        return bl;
    }

    boolean setup(ImagePlus imagePlus) {
        int n;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.setup");
        }
        if ((n = imagePlus.getType()) != 4) {
            return false;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n2 = imagePlus.getID();
        int n3 = imagePlus.getCurrentSlice();
        if (n2 != this.previousImageID || n3 != this.previousSlice || this.flag) {
            this.flag = false;
            this.numSlices = imagePlus.getStackSize();
            this.stack = imagePlus.getStack();
            this.width = this.stack.getWidth();
            this.height = this.stack.getHeight();
            this.numPixels = this.width * this.height;
            this.hSource = new byte[this.numPixels];
            this.sSource = new byte[this.numPixels];
            this.bSource = new byte[this.numPixels];
            ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height);
            imagePlus.setProperty("Mask", byteProcessor);
            ColorProcessor colorProcessor = (ColorProcessor)imageProcessor;
            IJ.showStatus("Converting colour space...");
            if (this.colorSpace == 1) {
                colorProcessor.getRGB(this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 0) {
                colorProcessor.getHSB(this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 2) {
                this.getLab(colorProcessor, this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 3) {
                this.getYUV(colorProcessor, this.hSource, this.sSource, this.bSource);
            }
            IJ.showStatus("");
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                Color color = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
                byArray[i] = (byte)color.getRed();
                byArray2[i] = (byte)color.getGreen();
                byArray3[i] = (byte)color.getBlue();
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
            ByteProcessor byteProcessor2 = new ByteProcessor(this.width, this.height, this.hSource, indexColorModel);
            ImagePlus imagePlus2 = new ImagePlus("Hue", byteProcessor2);
            ByteProcessor byteProcessor3 = new ByteProcessor(this.width, this.height, this.sSource, indexColorModel);
            ImagePlus imagePlus3 = new ImagePlus("Sat", byteProcessor3);
            ByteProcessor byteProcessor4 = new ByteProcessor(this.width, this.height, this.bSource, indexColorModel);
            ImagePlus imagePlus4 = new ImagePlus("Bri", byteProcessor4);
            this.plot.setHistogram(imagePlus2, 0);
            this.splot.setHistogram(imagePlus3, 1);
            this.bplot.setHistogram(imagePlus4, 2);
            if (!this.applyingStack) {
                this.autoSetThreshold();
            }
            imagePlus.updateAndDraw();
        }
        this.previousImageID = n2;
        this.previousSlice = n3;
        return imageProcessor != null;
    }

    void autoSetThreshold() {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.autoSetThreshold");
        }
        boolean bl = this.darkBackground != null && this.darkBackground.getState();
        switch (this.colorSpace) {
            case 0: {
                int[] nArray = this.bplot.getHistogram();
                if (nArray == null) {
                    return;
                }
                int n = thresholder.getThreshold(method, nArray);
                if (bl) {
                    this.minBri = n + 1;
                    this.maxBri = 255;
                    break;
                }
                this.minBri = 0;
                this.maxBri = n;
                break;
            }
            case 1: {
                int[] nArray = this.plot.getHistogram();
                int n = thresholder.getThreshold(method, nArray);
                if (bl) {
                    this.minHue = n + 1;
                    this.maxHue = 255;
                } else {
                    this.minHue = 0;
                    this.maxHue = n;
                }
                int[] nArray2 = this.splot.getHistogram();
                n = thresholder.getThreshold(method, nArray2);
                if (bl) {
                    this.minSat = n + 1;
                    this.maxSat = 255;
                } else {
                    this.minSat = 0;
                    this.maxSat = n;
                }
                int[] nArray3 = this.bplot.getHistogram();
                n = thresholder.getThreshold(method, nArray3);
                if (bl) {
                    this.minBri = n + 1;
                    this.maxBri = 255;
                    break;
                }
                this.minBri = 0;
                this.maxBri = n;
                break;
            }
            case 2: 
            case 3: {
                int[] nArray = this.plot.getHistogram();
                int n = thresholder.getThreshold(method, nArray);
                if (bl) {
                    this.minHue = n + 1;
                    this.maxHue = 255;
                    break;
                }
                this.minHue = 0;
                this.maxHue = n;
            }
        }
        this.updateScrollBars();
        this.updateLabels();
        this.updatePlot();
    }

    void updatePlot() {
        this.plot.minHue = this.minHue;
        this.plot.maxHue = this.maxHue;
        this.plot.repaint();
        this.splot.minHue = this.minSat;
        this.splot.maxHue = this.maxSat;
        this.splot.repaint();
        this.bplot.minHue = this.minBri;
        this.bplot.maxHue = this.maxBri;
        this.bplot.repaint();
    }

    void updateLabels() {
        this.label1.setText("" + this.minHue);
        this.label2.setText("" + this.maxHue);
        this.label3.setText("" + this.minSat);
        this.label4.setText("" + this.maxSat);
        this.label5.setText("" + this.minBri);
        this.label6.setText("" + this.maxBri);
    }

    void updateNames() {
        if (this.colorSpace == 1) {
            this.labelh.setText("Red");
            this.labels.setText("Green");
            this.labelb.setText("Blue");
        } else if (this.colorSpace == 0) {
            this.labelh.setText("Hue");
            this.labels.setText("Saturation");
            this.labelb.setText("Brightness");
        } else if (this.colorSpace == 2) {
            this.labelh.setText("L*");
            this.labels.setText("a*");
            this.labelb.setText("b*");
        } else if (this.colorSpace == 3) {
            this.labelh.setText("Y");
            this.labels.setText("U");
            this.labelb.setText("V");
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue(this.minHue);
        this.maxSlider.setValue(this.maxHue);
        this.minSlider2.setValue(this.minSat);
        this.maxSlider2.setValue(this.maxSat);
        this.minSlider3.setValue(this.minBri);
        this.maxSlider3.setValue(this.maxBri);
    }

    void adjustMinHue(int n) {
        this.minHue = n;
        if (this.maxHue < this.minHue) {
            this.maxHue = this.minHue;
            this.maxSlider.setValue(this.maxHue);
        }
    }

    void adjustMaxHue(int n) {
        this.maxHue = n;
        if (this.minHue > this.maxHue) {
            this.minHue = this.maxHue;
            this.minSlider.setValue(this.minHue);
        }
    }

    void adjustMinSat(int n) {
        this.minSat = n;
        if (this.maxSat < this.minSat) {
            this.maxSat = this.minSat;
            this.maxSlider2.setValue(this.maxSat);
        }
    }

    void adjustMaxSat(int n) {
        this.maxSat = n;
        if (this.minSat > this.maxSat) {
            this.minSat = this.maxSat;
            this.minSlider2.setValue(this.minSat);
        }
    }

    void adjustMinBri(int n) {
        this.minBri = n;
        if (this.maxBri < this.minBri) {
            this.maxBri = this.minBri;
            this.maxSlider3.setValue(this.maxBri);
        }
    }

    void adjustMaxBri(int n) {
        this.maxBri = n;
        if (this.minBri > this.maxBri) {
            this.minBri = this.maxBri;
            this.minSlider3.setValue(this.minBri);
        }
    }

    void apply(ImagePlus imagePlus) {
        ImageProcessor imageProcessor;
        int n;
        int n2;
        int n3;
        int n4;
        ImageProcessor imageProcessor2;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.apply");
        }
        if ((imageProcessor2 = (ImageProcessor)imagePlus.getProperty("Mask")) == null) {
            return;
        }
        byte[] byArray = (byte[])imageProcessor2.getPixels();
        int n5 = -1;
        int n6 = 0;
        if (this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 < this.minHue || n3 > this.maxHue || n2 < this.minSat || n2 > this.maxSat || n < this.minBri || n > this.maxBri ? n6 : n5;
            }
        } else if (!(this.bandPassH.getState() || this.bandPassS.getState() || this.bandPassB.getState())) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 >= this.minHue && n3 <= this.maxHue || n2 >= this.minSat && n2 <= this.maxSat || n >= this.minBri && n <= this.maxBri ? n6 : n5;
            }
        } else if (this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 < this.minHue || n3 > this.maxHue || n2 < this.minSat || n2 > this.maxSat || n >= this.minBri && n <= this.maxBri ? n6 : n5;
            }
        } else if (!this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 >= this.minHue && n3 <= this.maxHue || n2 >= this.minSat && n2 <= this.maxSat || n < this.minBri || n > this.maxBri ? n6 : n5;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 < this.minHue || n3 > this.maxHue || n2 >= this.minSat && n2 <= this.maxSat || n >= this.minBri && n <= this.maxBri ? n6 : n5;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 >= this.minHue && n3 <= this.maxHue || n2 < this.minSat || n2 > this.maxSat || n < this.minBri || n > this.maxBri ? n6 : n5;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 >= this.minHue && n3 <= this.maxHue || n2 < this.minSat || n2 > this.maxSat || n >= this.minBri && n <= this.maxBri ? n6 : n5;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (n4 = 0; n4 < this.numPixels; ++n4) {
                n3 = this.hSource[n4] & 0xFF;
                n2 = this.sSource[n4] & 0xFF;
                n = this.bSource[n4] & 0xFF;
                byArray[n4] = n3 < this.minHue || n3 > this.maxHue || n2 >= this.minSat && n2 <= this.maxSat || n < this.minBri || n > this.maxBri ? n6 : n5;
            }
        }
        if ((imageProcessor = imagePlus.getProcessor()) == null) {
            return;
        }
        if (mode == 3) {
            int[] nArray = (int[])imageProcessor.getPixels();
            n2 = Prefs.blackBackground ? -1 : -16777216;
            n = Prefs.blackBackground ? -16777216 : -1;
            for (int i = 0; i < this.numPixels; ++i) {
                nArray[i] = byArray[i] != 0 ? n2 : n;
            }
        } else {
            imageProcessor.setColor(this.thresholdColor());
            imageProcessor.fill(imageProcessor2);
        }
    }

    Color thresholdColor() {
        Color color = null;
        switch (mode) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.white;
                break;
            }
            case 2: {
                color = Color.black;
                break;
            }
            case 3: {
                color = Color.black;
            }
        }
        return color;
    }

    void applyStack() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            return;
        }
        this.applyingStack = true;
        for (int i = 1; i <= this.numSlices; ++i) {
            imagePlus.setSlice(i);
            if (!this.checkImage()) {
                return;
            }
            this.apply(imagePlus);
        }
        this.applyingStack = false;
    }

    void reset(ImagePlus imagePlus) {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.reset");
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImagePlus imagePlus2 = (ImagePlus)imagePlus.getProperty("OriginalImage");
        if (imagePlus2 == null) {
            imagePlus2 = imagePlus.createImagePlus();
            imagePlus2.setTitle(imagePlus.getTitle() + " (Original)");
            imagePlus2.setProcessor(imageProcessor.duplicate());
            imagePlus.setProperty("OriginalImage", imagePlus2);
        }
        int[] nArray = (int[])imagePlus2.getProcessor().getPixels();
        int[] nArray2 = (int[])imageProcessor.getPixels();
        for (int i = 0; i < this.numPixels; ++i) {
            nArray2[i] = nArray[i];
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        ImagePlus imagePlus;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.windowActivated ");
        }
        if ((imagePlus = WindowManager.getCurrentImage()) == null || imagePlus.getBitDepth() != 24) {
            IJ.beep();
            IJ.showStatus("No RGB image");
        } else {
            this.setup(imagePlus);
            this.reset(imagePlus);
            this.filteredB.setEnabled(true);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.set("cthresholder.dark", this.darkBackground.getState());
        ColorThresholder colorThresholder = this;
        synchronized (colorThresholder) {
            this.notify();
        }
    }

    public void getLab(ImageProcessor imageProcessor, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        double d = 0.3333333333333333;
        double d2 = 0.13793103448275862;
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = imageProcessor.getPixel(j, i);
                double d3 = (double)((n4 & 0xFF0000) >> 16) / 255.0;
                double d4 = (double)((n4 & 0xFF00) >> 8) / 255.0;
                double d5 = (double)(n4 & 0xFF) / 255.0;
                double d6 = 0.430587 * d3 + 0.341545 * d4 + 0.178336 * d5;
                double d7 = 0.222021 * d3 + 0.706645 * d4 + 0.0713342 * d5;
                double d8 = 0.0201837 * d3 + 0.129551 * d4 + 0.939234 * d5;
                double d9 = d6 > 0.008856 ? Math.pow(d6, d) : 7.78707 * d6 + d2;
                double d10 = d7 > 0.008856 ? Math.pow(d7, d) : 7.78707 * d7 + d2;
                double d11 = d8 > 0.008856 ? Math.pow(d8, d) : 7.78707 * d8 + d2;
                double d12 = 116.0 * d10 - 16.0;
                double d13 = 500.0 * (d9 - d10);
                double d14 = 200.0 * (d10 - d11);
                d12 = (int)(d12 * 2.55);
                d13 = (int)Math.floor(1.0625 * d13 + 128.0 + 0.5);
                d14 = (int)Math.floor(1.0625 * d14 + 128.0 + 0.5);
                byArray[n] = (byte)((int)(d12 < 0.0 ? 0.0 : (d12 > 255.0 ? 255.0 : d12)) & 0xFF);
                byArray2[n] = (byte)((int)(d13 < 0.0 ? 0.0 : (d13 > 255.0 ? 255.0 : d13)) & 0xFF);
                byArray3[n] = (byte)((int)(d14 < 0.0 ? 0.0 : (d14 > 255.0 ? 255.0 : d14)) & 0xFF);
                ++n;
            }
        }
    }

    public void getYUV(ImageProcessor imageProcessor, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = imageProcessor.getPixel(j, i);
                int n5 = (n4 & 0xFF0000) >> 16;
                int n6 = (n4 & 0xFF00) >> 8;
                int n7 = n4 & 0xFF;
                double d = 0.299 * (double)n5 + 0.587 * (double)n6 + 0.114 * (double)n7;
                byArray[n] = (byte)Math.floor(d + 0.5);
                byArray2[n] = (byte)(128 + (int)Math.floor(0.493 * ((double)n7 - d) + 0.5));
                byArray3[n] = (byte)(128 + (int)Math.floor(0.877 * ((double)n5 - d) + 0.5));
                ++n;
            }
        }
    }

    public static void RGBtoLab() {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.getBitDepth() == 24) {
            ColorThresholder.RGBtoLab(imagePlus.getProcessor());
            imagePlus.updateAndDraw();
        }
    }

    static void RGBtoLab(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        boolean bl = false;
        double d = 0.3333333333333333;
        double d2 = 0.13793103448275862;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = imageProcessor.getPixel(j, i);
                double d3 = (double)((n3 & 0xFF0000) >> 16) / 255.0;
                double d4 = (double)((n3 & 0xFF00) >> 8) / 255.0;
                double d5 = (double)(n3 & 0xFF) / 255.0;
                double d6 = 0.430587 * d3 + 0.341545 * d4 + 0.178336 * d5;
                double d7 = 0.222021 * d3 + 0.706645 * d4 + 0.0713342 * d5;
                double d8 = 0.0201837 * d3 + 0.129551 * d4 + 0.939234 * d5;
                double d9 = d6 > 0.008856 ? Math.pow(d6, d) : 7.78707 * d6 + d2;
                double d10 = d7 > 0.008856 ? Math.pow(d7, d) : 7.78707 * d7 + d2;
                double d11 = d8 > 0.008856 ? Math.pow(d8, d) : 7.78707 * d8 + d2;
                double d12 = 116.0 * d10 - 16.0;
                double d13 = 500.0 * (d9 - d10);
                double d14 = 200.0 * (d10 - d11);
                d13 = Math.floor(1.0625 * d13 + 128.0 + 0.5);
                d14 = Math.floor(1.0625 * d14 + 128.0 + 0.5);
                int n4 = (int)(d12 < 0.0 ? 0.0 : (d12 > 255.0 ? 255.0 : (d12 *= 2.55)));
                int n5 = (int)(d13 < 0.0 ? 0.0 : (d13 > 255.0 ? 255.0 : d13));
                int n6 = (int)(d14 < 0.0 ? 0.0 : (d14 > 255.0 ? 255.0 : d14));
                imageProcessor.putPixel(j, i, ((n4 & 0xFF) << 16) + ((n5 & 0xFF) << 8) + (n6 & 0xFF));
            }
        }
    }

    public static void RGBtoYUV() {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.getBitDepth() == 24) {
            ColorThresholder.RGBtoLab(imagePlus.getProcessor());
            imagePlus.updateAndDraw();
        }
    }

    static void RGBtoYUV(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        boolean bl = false;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = imageProcessor.getPixel(j, i);
                int n4 = (n3 & 0xFF0000) >> 16;
                int n5 = (n3 & 0xFF00) >> 8;
                int n6 = n3 & 0xFF;
                double d = 0.299 * (double)n4 + 0.587 * (double)n5 + 0.114 * (double)n6;
                int n7 = (int)Math.floor(d + 0.5);
                int n8 = 128 + (int)Math.floor(0.493 * ((double)n6 - d) + 0.5);
                int n9 = 128 + (int)Math.floor(0.877 * ((double)n4 - d) + 0.5);
                imageProcessor.putPixel(j, i, (((n7 < 0 ? 0 : (n7 > 255 ? 255 : n7)) & 0xFF) << 16) + (((n8 < 0 ? 0 : (n8 > 255 ? 255 : n8)) & 0xFF) << 8) + ((n9 < 0 ? 0 : (n9 > 255 ? 255 : n9)) & 0xFF));
                imageProcessor.putPixel(j, i, ((n7 & 0xFF) << 16) + ((n8 & 0xFF) << 8) + (n9 & 0xFF));
            }
        }
    }

    static {
        methodNames = AutoThresholder.getMethods();
        method = methodNames[0];
        thresholder = new AutoThresholder();
        modes = new String[]{"Red", "White", "Black", "B&W"};
        mode = 0;
    }

    class BandPlot
    extends Canvas
    implements Measurements,
    MouseListener {
        final int WIDTH = 256;
        final int HEIGHT = 64;
        double minHue = 0.0;
        double minSat = 0.0;
        double minBri = 0.0;
        double maxHue = 255.0;
        double maxSat = 255.0;
        double maxBri = 255.0;
        int[] histogram;
        Color[] hColors;
        int hmax;
        Image os;
        Graphics osg;

        public BandPlot() {
            this.addMouseListener(this);
            this.setSize(257, 65);
        }

        public Dimension getPreferredSize() {
            return new Dimension(257, 65);
        }

        void setHistogram(ImagePlus imagePlus, int n) {
            block23: {
                block28: {
                    block30: {
                        block29: {
                            block25: {
                                block27: {
                                    block26: {
                                        byte[] byArray;
                                        byte[] byArray2;
                                        byte[] byArray3;
                                        block21: {
                                            block24: {
                                                block22: {
                                                    ImageProcessor imageProcessor = imagePlus.getProcessor();
                                                    ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, 9, null);
                                                    int n2 = 0;
                                                    this.histogram = imageStatistics.histogram;
                                                    for (int i = 0; i < imageStatistics.nBins; ++i) {
                                                        if (this.histogram[i] <= n2) continue;
                                                        n2 = this.histogram[i];
                                                    }
                                                    this.hmax = (int)((double)n2 * 1.15);
                                                    this.os = null;
                                                    ColorModel colorModel = imageProcessor.getColorModel();
                                                    if (!(colorModel instanceof IndexColorModel)) {
                                                        return;
                                                    }
                                                    IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                                                    int n3 = indexColorModel.getMapSize();
                                                    if (n3 != 256) {
                                                        return;
                                                    }
                                                    byArray3 = new byte[256];
                                                    byArray2 = new byte[256];
                                                    byArray = new byte[256];
                                                    indexColorModel.getReds(byArray3);
                                                    indexColorModel.getGreens(byArray2);
                                                    indexColorModel.getBlues(byArray);
                                                    this.hColors = new Color[256];
                                                    if (ColorThresholder.this.colorSpace != 1) break block21;
                                                    if (n != 0) break block22;
                                                    for (int i = 0; i < 256; ++i) {
                                                        this.hColors[i] = new Color(i & 0xFF, 0, 0);
                                                    }
                                                    break block23;
                                                }
                                                if (n != 1) break block24;
                                                for (int i = 0; i < 256; ++i) {
                                                    this.hColors[i] = new Color(0, i & 0xFF, 0);
                                                }
                                                break block23;
                                            }
                                            if (n != 2) break block23;
                                            for (int i = 0; i < 256; ++i) {
                                                this.hColors[i] = new Color(0, 0, i & 0xFF);
                                            }
                                            break block23;
                                        }
                                        if (ColorThresholder.this.colorSpace != 0) break block25;
                                        if (n != 0) break block26;
                                        for (int i = 0; i < 256; ++i) {
                                            this.hColors[i] = new Color(byArray3[i] & 0xFF, byArray2[i] & 0xFF, byArray[i] & 0xFF);
                                        }
                                        break block23;
                                    }
                                    if (n != 1) break block27;
                                    for (int i = 0; i < 256; ++i) {
                                        this.hColors[i] = new Color(255, 255 - i & 0xFF, 255 - i & 0xFF);
                                    }
                                    break block23;
                                }
                                if (n != 2) break block23;
                                for (int i = 0; i < 256; ++i) {
                                    this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                                }
                                break block23;
                            }
                            if (ColorThresholder.this.colorSpace != 2) break block28;
                            if (n != 0) break block29;
                            for (int i = 0; i < 256; ++i) {
                                this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                            }
                            break block23;
                        }
                        if (n != 1) break block30;
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, 0);
                        }
                        break block23;
                    }
                    if (n != 2) break block23;
                    for (int i = 0; i < 256; ++i) {
                        this.hColors[i] = new Color(i & 0xFF, i & 0xFF, 255 - i & 0xFF);
                    }
                    break block23;
                }
                if (ColorThresholder.this.colorSpace == 3) {
                    if (n == 0) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                        }
                    } else if (n == 1) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color((int)(36.0 + (double)(255 - i) / 1.4) & 0xFF, 255 - i & 0xFF, i & 0xFF);
                        }
                    } else if (n == 2) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, (int)(83.0 + (double)(255 - i) / 2.87) & 0xFF);
                        }
                    }
                }
            }
        }

        int[] getHistogram() {
            return this.histogram;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n = 0;
            if (this.histogram != null) {
                if (this.os == null) {
                    this.os = this.createImage(256, 64);
                    this.osg = this.os.getGraphics();
                    this.osg.setColor(new Color(140, 152, 144));
                    this.osg.fillRect(0, 0, 256, 64);
                    for (int i = 0; i < 256; ++i) {
                        if (this.hColors != null) {
                            this.osg.setColor(this.hColors[i]);
                        }
                        n = 64 - 64 * this.histogram[i] / this.hmax - 6;
                        this.osg.drawLine(i, 64, i, n);
                        this.osg.setColor(Color.black);
                        this.osg.drawLine(i, n, i, n);
                    }
                    this.osg.dispose();
                }
                if (this.os != null) {
                    graphics.drawImage(this.os, 0, 0, this);
                }
            } else {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, 256, 64);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(0, 58, 256, 58);
            graphics.drawRect(0, 0, 256, 64);
            graphics.drawRect((int)this.minHue, 1, (int)(this.maxHue - this.minHue), 57);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }
}

