/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class FFTFilter
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private String arg;
    private static int filterIndex = 1;
    private FHT fht;
    private int slice;
    private int stackSize = 1;
    private static double filterLargeDia = 40.0;
    private static double filterSmallDia = 3.0;
    private static int choiceIndex = 0;
    private static String[] choices = new String[]{"None", "Horizontal", "Vertical"};
    private static String choiceDia = choices[0];
    private static double toleranceDia = 5.0;
    private static boolean doScalingDia = true;
    private static boolean saturateDia = true;
    private static boolean displayFilter;
    private static boolean processStack;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        this.stackSize = imagePlus.getStackSize();
        this.fht = (FHT)imagePlus.getProperty("FHT");
        if (this.fht != null) {
            IJ.error("FFT Filter", "Spatial domain image required");
            return 4096;
        }
        if (!this.showBandpassDialog(imagePlus)) {
            return 4096;
        }
        return processStack ? 63 : 31;
    }

    public void run(ImageProcessor imageProcessor) {
        ++this.slice;
        this.filter(imageProcessor);
    }

    void filter(ImageProcessor imageProcessor) {
        ImageProcessor imageProcessor2 = imageProcessor;
        if (imageProcessor2 instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            imageProcessor2 = ((ColorProcessor)imageProcessor2).getBrightness();
        }
        Rectangle rectangle = imageProcessor2.getRoi();
        int n = Math.max(rectangle.width, rectangle.height);
        double d = (100.0 - toleranceDia) / 100.0;
        boolean bl = doScalingDia;
        boolean bl2 = saturateDia;
        IJ.showProgress(1, 20);
        int n2 = 2;
        while ((double)n2 < 1.5 * (double)n) {
            n2 *= 2;
        }
        double d2 = 2.0 * filterLargeDia / (double)n2;
        double d3 = 2.0 * filterSmallDia / (double)n2;
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = (int)Math.round((double)(n2 - rectangle.width) / 2.0);
        rectangle2.y = (int)Math.round((double)(n2 - rectangle.height) / 2.0);
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        this.showStatus("Pad to " + n2 + "x" + n2);
        imageProcessor2 = this.tileMirror(imageProcessor2, n2, n2, rectangle2.x, rectangle2.y);
        IJ.showProgress(2, 20);
        this.showStatus(n2 + "x" + n2 + " forward transform");
        FHT fHT = new FHT(imageProcessor2);
        fHT.setShowProgress(false);
        fHT.transform();
        IJ.showProgress(9, 20);
        this.showStatus("Filter in frequency domain");
        this.filterLargeSmall(fHT, d2, d3, choiceIndex, d);
        IJ.showProgress(11, 20);
        this.showStatus("Inverse transform");
        fHT.inverseTransform();
        IJ.showProgress(19, 20);
        this.showStatus("Crop and convert to original type");
        fHT.setRoi(rectangle2);
        imageProcessor2 = fHT.crop();
        if (bl) {
            ImagePlus imagePlus = new ImagePlus(this.imp.getTitle() + "-filtered", imageProcessor2);
            new ContrastEnhancer().stretchHistogram(imagePlus, bl2 ? 1.0 : 0.0);
            imageProcessor2 = imagePlus.getProcessor();
        }
        int n3 = this.imp.getBitDepth();
        switch (n3) {
            case 8: {
                imageProcessor2 = imageProcessor2.convertToByte(bl);
                break;
            }
            case 16: {
                imageProcessor2 = imageProcessor2.convertToShort(bl);
                break;
            }
            case 24: {
                imageProcessor.snapshot();
                this.showStatus("Setting brightness");
                ((ColorProcessor)imageProcessor).setBrightness((FloatProcessor)imageProcessor2);
                break;
            }
        }
        if (n3 != 24) {
            imageProcessor.snapshot();
            imageProcessor.copyBits(imageProcessor2, rectangle.x, rectangle.y, 0);
        }
        imageProcessor.resetMinAndMax();
        IJ.showProgress(20, 20);
    }

    void showStatus(String string) {
        if (this.stackSize > 1 && processStack) {
            IJ.showStatus("FFT Filter: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(string);
        }
    }

    public ImageProcessor tileMirror(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 < 0 || n3 > n - 1 || n4 < 0 || n4 > n2 - 1) {
            IJ.error("Image to be tiled is out of bounds.");
            return null;
        }
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n, n2);
        ImageProcessor imageProcessor3 = imageProcessor.crop();
        int n7 = imageProcessor3.getWidth();
        int n8 = imageProcessor3.getHeight();
        int n9 = (int)Math.ceil((double)n3 / (double)n7);
        int n10 = (int)Math.ceil((double)(n - n3) / (double)n7);
        int n11 = (int)Math.ceil((double)n4 / (double)n8);
        int n12 = (int)Math.ceil((double)(n2 - n4) / (double)n8);
        if ((double)(n9 % 2) > 0.5) {
            imageProcessor3.flipHorizontal();
        }
        if ((double)(n11 % 2) > 0.5) {
            imageProcessor3.flipVertical();
        }
        for (n6 = -n9; n6 < n10; n6 += 2) {
            for (n5 = -n11; n5 < n12; n5 += 2) {
                imageProcessor2.insert(imageProcessor3, n3 - n6 * n7, n4 - n5 * n8);
            }
        }
        imageProcessor3.flipHorizontal();
        for (n6 = -n9 + 1; n6 < n10; n6 += 2) {
            for (n5 = -n11; n5 < n12; n5 += 2) {
                imageProcessor2.insert(imageProcessor3, n3 - n6 * n7, n4 - n5 * n8);
            }
        }
        imageProcessor3.flipVertical();
        for (n6 = -n9 + 1; n6 < n10; n6 += 2) {
            for (n5 = -n11 + 1; n5 < n12; n5 += 2) {
                imageProcessor2.insert(imageProcessor3, n3 - n6 * n7, n4 - n5 * n8);
            }
        }
        imageProcessor3.flipHorizontal();
        for (n6 = -n9; n6 < n10; n6 += 2) {
            for (n5 = -n11 + 1; n5 < n12; n5 += 2) {
                imageProcessor2.insert(imageProcessor3, n3 - n6 * n7, n4 - n5 * n8);
            }
        }
        return imageProcessor2;
    }

    void filterLargeSmall(ImageProcessor imageProcessor, double d, double d2, int n, double d3) {
        float f;
        float f2;
        int n2;
        int n3;
        float f3;
        float f4;
        int n4;
        int n5;
        int n6;
        int n7 = imageProcessor.getWidth();
        float[] fArray = (float[])imageProcessor.getPixels();
        float[] fArray2 = new float[n7 * n7];
        for (n6 = 0; n6 < n7 * n7; ++n6) {
            fArray2[n6] = 1.0f;
        }
        double d4 = d * d;
        double d5 = d2 * d2;
        d3 *= d3;
        for (n5 = 1; n5 < n7 / 2; ++n5) {
            n6 = n5 * n7;
            n4 = (n7 - n5) * n7;
            f4 = (float)Math.exp((double)(-(n5 * n5)) * d4);
            f3 = (float)Math.exp((double)(-(n5 * n5)) * d5);
            for (n3 = 1; n3 < n7 / 2; ++n3) {
                n2 = n7 - n3;
                f2 = (float)Math.exp((double)(-(n3 * n3)) * d4);
                f = (float)Math.exp((double)(-(n3 * n3)) * d5);
                float f5 = (1.0f - f4 * f2) * f3 * f;
                switch (n) {
                    case 1: {
                        f5 *= 1.0f - (float)Math.exp((double)(-(n3 * n3)) * d3);
                        break;
                    }
                    case 2: {
                        f5 *= 1.0f - (float)Math.exp((double)(-(n5 * n5)) * d3);
                    }
                }
                int n8 = n3 + n6;
                fArray[n8] = fArray[n8] * f5;
                int n9 = n3 + n4;
                fArray[n9] = fArray[n9] * f5;
                int n10 = n2 + n6;
                fArray[n10] = fArray[n10] * f5;
                int n11 = n2 + n4;
                fArray[n11] = fArray[n11] * f5;
                int n12 = n3 + n6;
                fArray2[n12] = fArray2[n12] * f5;
                int n13 = n3 + n4;
                fArray2[n13] = fArray2[n13] * f5;
                int n14 = n2 + n6;
                fArray2[n14] = fArray2[n14] * f5;
                int n15 = n2 + n4;
                fArray2[n15] = fArray2[n15] * f5;
            }
        }
        n5 = n7 * (n7 / 2);
        f4 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d4);
        f3 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d5);
        float f6 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d3);
        int n16 = n7 / 2;
        fArray[n16] = fArray[n16] * ((1.0f - f4) * f3);
        int n17 = n5;
        fArray[n17] = fArray[n17] * ((1.0f - f4) * f3);
        int n18 = n7 / 2 + n5;
        fArray[n18] = fArray[n18] * ((1.0f - f4 * f4) * f3 * f3);
        int n19 = n7 / 2;
        fArray2[n19] = fArray2[n19] * ((1.0f - f4) * f3);
        int n20 = n5;
        fArray2[n20] = fArray2[n20] * ((1.0f - f4) * f3);
        int n21 = n7 / 2 + n5;
        fArray2[n21] = fArray2[n21] * ((1.0f - f4 * f4) * f3 * f3);
        switch (n) {
            case 1: {
                int n22 = n7 / 2;
                fArray[n22] = fArray[n22] * (1.0f - f6);
                fArray[n5] = 0.0f;
                int n23 = n7 / 2 + n5;
                fArray[n23] = fArray[n23] * (1.0f - f6);
                int n24 = n7 / 2;
                fArray2[n24] = fArray2[n24] * (1.0f - f6);
                fArray2[n5] = 0.0f;
                int n25 = n7 / 2 + n5;
                fArray2[n25] = fArray2[n25] * (1.0f - f6);
                break;
            }
            case 2: {
                fArray[n7 / 2] = 0.0f;
                int n26 = n5;
                fArray[n26] = fArray[n26] * (1.0f - f6);
                int n27 = n7 / 2 + n5;
                fArray[n27] = fArray[n27] * (1.0f - f6);
                fArray2[n7 / 2] = 0.0f;
                int n28 = n5;
                fArray2[n28] = fArray2[n28] * (1.0f - f6);
                int n29 = n7 / 2 + n5;
                fArray2[n29] = fArray2[n29] * (1.0f - f6);
            }
        }
        f4 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d4);
        f3 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d5);
        block21: for (n3 = 1; n3 < n7 / 2; ++n3) {
            n2 = n7 - n3;
            f2 = (float)Math.exp((double)(-(n3 * n3)) * d4);
            f = (float)Math.exp((double)(-(n3 * n3)) * d5);
            switch (n) {
                case 0: {
                    int n30 = n3;
                    fArray[n30] = fArray[n30] * ((1.0f - f2) * f);
                    int n31 = n2;
                    fArray[n31] = fArray[n31] * ((1.0f - f2) * f);
                    int n32 = n3 + n5;
                    fArray[n32] = fArray[n32] * ((1.0f - f2 * f4) * f * f3);
                    int n33 = n2 + n5;
                    fArray[n33] = fArray[n33] * ((1.0f - f2 * f4) * f * f3);
                    int n34 = n3;
                    fArray2[n34] = fArray2[n34] * ((1.0f - f2) * f);
                    int n35 = n2;
                    fArray2[n35] = fArray2[n35] * ((1.0f - f2) * f);
                    int n36 = n3 + n5;
                    fArray2[n36] = fArray2[n36] * ((1.0f - f2 * f4) * f * f3);
                    int n37 = n2 + n5;
                    fArray2[n37] = fArray2[n37] * ((1.0f - f2 * f4) * f * f3);
                    continue block21;
                }
                case 1: {
                    f6 = (float)Math.exp((double)(-(n3 * n3)) * d3);
                    int n38 = n3;
                    fArray[n38] = fArray[n38] * ((1.0f - f2) * f * (1.0f - f6));
                    int n39 = n2;
                    fArray[n39] = fArray[n39] * ((1.0f - f2) * f * (1.0f - f6));
                    int n40 = n3 + n5;
                    fArray[n40] = fArray[n40] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    int n41 = n2 + n5;
                    fArray[n41] = fArray[n41] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    int n42 = n3;
                    fArray2[n42] = fArray2[n42] * ((1.0f - f2) * f * (1.0f - f6));
                    int n43 = n2;
                    fArray2[n43] = fArray2[n43] * ((1.0f - f2) * f * (1.0f - f6));
                    int n44 = n3 + n5;
                    fArray2[n44] = fArray2[n44] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    int n45 = n2 + n5;
                    fArray2[n45] = fArray2[n45] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    continue block21;
                }
                case 2: {
                    f6 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d3);
                    fArray[n3] = 0.0f;
                    fArray[n2] = 0.0f;
                    int n46 = n3 + n5;
                    fArray[n46] = fArray[n46] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    int n47 = n2 + n5;
                    fArray[n47] = fArray[n47] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    fArray2[n3] = 0.0f;
                    fArray2[n2] = 0.0f;
                    int n48 = n3 + n5;
                    fArray2[n48] = fArray2[n48] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                    int n49 = n2 + n5;
                    fArray2[n49] = fArray2[n49] * ((1.0f - f2 * f4) * f * f3 * (1.0f - f6));
                }
            }
        }
        f2 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d4);
        f = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d5);
        block22: for (int i = 1; i < n7 / 2; ++i) {
            n6 = i * n7;
            n4 = (n7 - i) * n7;
            f4 = (float)Math.exp((double)(-(i * i)) * d4);
            f3 = (float)Math.exp((double)(-(i * i)) * d5);
            switch (n) {
                case 0: {
                    int n50 = n6;
                    fArray[n50] = fArray[n50] * ((1.0f - f4) * f3);
                    int n51 = n4;
                    fArray[n51] = fArray[n51] * ((1.0f - f4) * f3);
                    int n52 = n6 + n7 / 2;
                    fArray[n52] = fArray[n52] * ((1.0f - f4 * f2) * f3 * f);
                    int n53 = n4 + n7 / 2;
                    fArray[n53] = fArray[n53] * ((1.0f - f4 * f2) * f3 * f);
                    int n54 = n6;
                    fArray2[n54] = fArray2[n54] * ((1.0f - f4) * f3);
                    int n55 = n4;
                    fArray2[n55] = fArray2[n55] * ((1.0f - f4) * f3);
                    int n56 = n6 + n7 / 2;
                    fArray2[n56] = fArray2[n56] * ((1.0f - f4 * f2) * f3 * f);
                    int n57 = n4 + n7 / 2;
                    fArray2[n57] = fArray2[n57] * ((1.0f - f4 * f2) * f3 * f);
                    continue block22;
                }
                case 1: {
                    f6 = (float)Math.exp((double)(-(n7 / 2) * (n7 / 2)) * d3);
                    fArray[n6] = 0.0f;
                    fArray[n4] = 0.0f;
                    int n58 = n6 + n7 / 2;
                    fArray[n58] = fArray[n58] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    int n59 = n4 + n7 / 2;
                    fArray[n59] = fArray[n59] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    fArray2[n6] = 0.0f;
                    fArray2[n4] = 0.0f;
                    int n60 = n6 + n7 / 2;
                    fArray2[n60] = fArray2[n60] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    int n61 = n4 + n7 / 2;
                    fArray2[n61] = fArray2[n61] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    continue block22;
                }
                case 2: {
                    f6 = (float)Math.exp((double)(-(i * i)) * d3);
                    int n62 = n6;
                    fArray[n62] = fArray[n62] * ((1.0f - f4) * f3 * (1.0f - f6));
                    int n63 = n4;
                    fArray[n63] = fArray[n63] * ((1.0f - f4) * f3 * (1.0f - f6));
                    int n64 = n6 + n7 / 2;
                    fArray[n64] = fArray[n64] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    int n65 = n4 + n7 / 2;
                    fArray[n65] = fArray[n65] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    int n66 = n6;
                    fArray2[n66] = fArray2[n66] * ((1.0f - f4) * f3 * (1.0f - f6));
                    int n67 = n4;
                    fArray2[n67] = fArray2[n67] * ((1.0f - f4) * f3 * (1.0f - f6));
                    int n68 = n6 + n7 / 2;
                    fArray2[n68] = fArray2[n68] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                    int n69 = n4 + n7 / 2;
                    fArray2[n69] = fArray2[n69] * ((1.0f - f4 * f2) * f3 * f * (1.0f - f6));
                }
            }
        }
        if (displayFilter && this.slice == 1) {
            FHT fHT = new FHT(new FloatProcessor(n7, n7, fArray2, null));
            fHT.swapQuadrants();
            new ImagePlus("Filter", fHT).show();
        }
    }

    boolean showBandpassDialog(ImagePlus imagePlus) {
        GenericDialog genericDialog = new GenericDialog("FFT Bandpass Filter");
        genericDialog.addNumericField("Filter_large structures down to", filterLargeDia, 0, 4, "pixels");
        genericDialog.addNumericField("Filter_small structures up to", filterSmallDia, 0, 4, "pixels");
        genericDialog.addChoice("Suppress stripes:", choices, choiceDia);
        genericDialog.addNumericField("Tolerance of direction:", toleranceDia, 0, 2, "%");
        genericDialog.addCheckbox("Autoscale after filtering", doScalingDia);
        genericDialog.addCheckbox("Saturate image when autoscaling", saturateDia);
        genericDialog.addCheckbox("Display filter", displayFilter);
        if (this.stackSize > 1) {
            genericDialog.addCheckbox("Process entire stack", processStack);
        }
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-bandpass");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        if (genericDialog.invalidNumber()) {
            IJ.error("Error", "Invalid input number");
            return false;
        }
        filterLargeDia = genericDialog.getNextNumber();
        filterSmallDia = genericDialog.getNextNumber();
        choiceIndex = genericDialog.getNextChoiceIndex();
        choiceDia = choices[choiceIndex];
        toleranceDia = genericDialog.getNextNumber();
        doScalingDia = genericDialog.getNextBoolean();
        saturateDia = genericDialog.getNextBoolean();
        displayFilter = genericDialog.getNextBoolean();
        if (this.stackSize > 1) {
            processStack = genericDialog.getNextBoolean();
        }
        return true;
    }
}

