/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

public class BitBuffer {
    private int currentByte;
    private int currentBit;
    private byte[] byteBuffer;
    private int eofByte;
    private int[] backMask;
    private int[] frontMask;
    private boolean eofFlag;

    public BitBuffer(byte[] byArray) {
        this.byteBuffer = byArray;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byArray.length;
        this.backMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
        this.frontMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    }

    public int getBits(int n) {
        if (n == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int n2 = 0;
        while (n != 0 && !this.eofFlag) {
            int n3;
            if (n >= 8 - this.currentBit) {
                if (this.currentBit == 0) {
                    n2 <<= 8;
                    n3 = this.byteBuffer[this.currentByte];
                    n2 += n3 < 0 ? 256 + n3 : n3;
                    n -= 8;
                    ++this.currentByte;
                } else {
                    n2 <<= 8 - this.currentBit;
                    n2 += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                    n -= 8 - this.currentBit;
                    this.currentBit = 0;
                    ++this.currentByte;
                }
            } else {
                n2 <<= n;
                n3 = this.byteBuffer[this.currentByte];
                n3 = n3 < 0 ? 256 + n3 : n3;
                n2 += (n3 & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + n);
                this.currentBit += n;
                n = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return n2;
        }
        return n2;
    }
}

