\alias{gtkBoxPackEnd}
\name{gtkBoxPackEnd}
\title{gtkBoxPackEnd}
\description{Adds \code{child} to \code{box}, packed with reference to the end of \code{box}.  
The \code{child} is packed after (away from end of) any other child 
packed with reference to the end of \code{box}.}
\usage{gtkBoxPackEnd(object, child, expand = TRUE, fill = TRUE, padding = 0)}
\arguments{
\item{\code{object}}{[\code{\link{GtkBox}}]  a \code{\link{GtkBox}}}
\item{\code{child}}{[\code{\link{GtkWidget}}]  the \code{\link{GtkWidget}} to be added to \code{box}}
\item{\code{expand}}{[logical]  \code{TRUE} if the new child is to be given extra space allocated 
  to \code{box}. The extra space will be divided evenly between all children 
  of \code{box} that use this option}
\item{\code{fill}}{[logical]  \code{TRUE} if space given to \code{child} by the \code{expand} option is
  actually allocated to \code{child}, rather than just padding it.  This
  parameter has no effect if \code{expand} is set to \code{FALSE}.  A child is
  always allocated the full height of a \code{\link{GtkHBox}} and the full width 
  of a \code{\link{GtkVBox}}.  This option affects the other dimension}
\item{\code{padding}}{[numeric]  extra space in pixels to put between this child and its
  neighbors, over and above the global amount specified by
  \code{:spacing} property.  If \code{child} is a widget at one of the 
  reference ends of \code{box}, then \code{padding} pixels are also put between 
  \code{child} and the reference edge of \code{box}}
}
\section{encoding}{UTF-8}
\author{Derived by RGtkGen from GTK+ documentation}
\keyword{internal}
