% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varNBR2.R
\name{varNBR2}
\alias{varNBR2}
\title{Calculate normalized burn ratio 2 (NBR2)}
\usage{
varNBR2(swir1, swir2)
}
\arguments{
\item{swir1}{a \code{raster} with the the SWIR1 band of the capture.}

\item{swir2}{a \code{raster} with the the SWIR2 band of the capture.}
}
\value{
A NBR2 image in \code{raster} format.
}
\description{
\code{varNBR2} computes the NBR2 index from SWIR1 and SWIR2 bands.
}
\details{
The normalized burn ratio 2 (NRB) is an index to identify burned areas. 
In contrast to NBR, NRB2 highlights the sensitivity to water in vegetation
\insertCite{lutes2006firemon}{RGISTools}. This function is used within
\code{\link{ls7FolderToVar}}, \code{\link{ls8FolderToVar}},
\code{\link{modFolderToVar}} and \code{\link{senFolderToVar}}.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
img.dir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
img.files <- list.files(img.dir, pattern="\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")

# select the SWIR1 and SWIR2 bands
swir1 <- raster(img.files[6])
swir2 <- raster(img.files[7])
# calculate the NBR2 image
nbr2 <- varNBR2(swir1,swir2)
# plot the image
spplot(nbr2,col.regions=rev(heat.colors(20)))
}
\references{
\insertRef{lutes2006firemon}{RGISTools}
}
