% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls7Search.R
\name{ls7Search}
\alias{ls7Search}
\title{Search Landsat-7 images}
\usage{
ls7Search(startDate, endDate, AppRoot, verbose = FALSE,
  precise = FALSE, ...)
}
\arguments{
\item{startDate}{a \code{Date} class object with the starting date of the 
study period.}

\item{endDate}{a \code{Date} class object with the ending date of the 
study period.}

\item{AppRoot}{directory of the metadata file.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{precise}{logical argument. If \code{TRUE}, conducts a thorough search,
tile by tile (slower).}

\item{...}{arguments for nested functions:
 \itemize{
  \item \code{pathrow} a list of vectors with the path and row numbers of
  the tiles concerning the region of interest. This argument is mandatory
  if \code{extent} or \code{lonlat} are not provided. Ex. 
  \code{list(c(200,31),c(200,30))}.
  \item \code{lonlat} a vector with the longitude/latitude
  coordinates of the point of interest. Ex. \code{c(-1.64323,42.81687)}.
  \item \code{extent} an \code{extent}, \code{Raster*}, or 
  \code{Spatial*} object representing the region of interest with 
  longitude/latitude coordinates. This argument is mandatory if 
  \code{pathrow} or \code{lonlat} are not defined.
  
  \item column names in the .LS7MD \code{data.frame} and their values.
}}
}
\value{
a \code{data.frame} with the name of the images and their metadata.
}
\description{
\code{ls7Search} searches Landsat-7 images in the Landsat repository concerning
a particular location and date interval. The function returns a 
\code{data.frame} with the names of the images and their metadata.
}
\details{
\code{ls7Search} searches images in the metadata file. If the metadata was
downloaded before to the current directory, \code{ls7Search} will use this
metadata by default. In case the metadata was not downloaded before, 
\code{ls7Search} will make that call for you.

Landsat images are organized by tiles, which have a unique path and row
numbers according to the
\href{https://landsat.gsfc.nasa.gov/the-worldwide-reference-system/}{Worldide Reference System}.
The fastest way to search an image in the metadata file is by path and row
(\code{pathrow}). This method requires to know in advance the path and row
number of the tile that is relevant for your region of interest. From the
user's standpoint, the simplest way to search a time series of Landsat-7
images is by \code{extent}, \code{lonlat} or \code{polygon}, since they do 
not require any prior knowledge about the tiles.

The function can screen the results by any other attribute in the metadata.
For instance, to filter the imagery with an available preview, the 
\code{browseAvaliable=”Y”} must be added as an argument of the function
(see the examples).
}
\examples{
\dontrun{
src <- paste0(tempdir(),"/Path_for_downloading_folder")
# search by path and row numbers of a tile
search.res <- ls7Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                        endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                        pathrow = list(c(200,31),c(200,30)),
                        browseAvaliable = "Y",
                        AppRoot = src)
                  
# search by point coordinates (long/lat coordinates)
search.res <- ls7Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                        endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                        lonlat = c(-1.64323,42.81687),
                        browseAvaliable = "Y",
                        AppRoot = src)
                  
# search by extent (long/lat coordinates)
# load a spatial polygon object of Navarre
data(ex.navarre)
search.res <- ls7Search(startDate = as.Date("01-01-2011", "\%d-\%m-\%Y"),
                        endDate = as.Date("31-12-2013", "\%d-\%m-\%Y"),
                        extent = ex.navarre,
                        precise = TRUE,
                        browseAvaliable = "Y",
                        AppRoot = src)

# search by extent (fast mode)
search.res <- ls7Search(startDate = as.Date("01-01-2011","\%d-\%m-\%Y"),
                        endDate = as.Date("31-12-2013","\%d-\%m-\%Y"),
                        extent = ex.navarre,
                        precise = FALSE,
                        browseAvaliable = "Y",
                        AppRoot = src)
# remove metadata to free memory space
lsRemoveMetadata()
}
}
