% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastRGF_Classifier.R
\docType{class}
\name{FastRGF_Classifier}
\alias{FastRGF_Classifier}
\title{A Fast Regularized Greedy Forest classifier}
\usage{
# init <- FastRGF_Classifier$new(n_estimators = 500, max_depth = 6,
#                                      max_leaf = 50, tree_gain_ratio = 1.0,
#                                      min_samples_leaf = 5, loss = "LS", l1 = 1.0,
#                                      l2 = 1000.0, opt_algorithm = "rgf",
#                                      learning_rate = 0.001, max_bin = NULL,
#                                      min_child_weight = 5.0, data_l2 = 2.0,
#                                      sparse_max_features = 80000,
#                                      sparse_min_occurences = 5,
#                                      calc_prob="sigmoid", n_jobs = 1,
#                                      verbose = 0)
}
\description{
A Fast Regularized Greedy Forest classifier

A Fast Regularized Greedy Forest classifier
}
\details{
the \emph{fit} function builds a classifier from the training set (x, y).

the \emph{predict} function predicts the class for x.

the \emph{predict_proba} function predicts class probabilities for x.

the \emph{cleanup} function removes tempfiles used by this model. See the issue \emph{https://github.com/RGF-team/rgf/issues/75}, which explains in which cases the \emph{cleanup} function applies.

the \emph{get_params} function returns the parameters of the model.

the \emph{score} function returns the mean accuracy on the given test data and labels.
}
\section{Methods}{


\describe{
 \item{\code{FastRGF_Classifier$new(n_estimators = 500, max_depth = 6,
                                    max_leaf = 50, tree_gain_ratio = 1.0,
                                    min_samples_leaf = 5, loss = "LS", l1 = 1.0,
                                    l2 = 1000.0, opt_algorithm = "rgf",
                                    learning_rate = 0.001, max_bin = NULL,
                                    min_child_weight = 5.0, data_l2 = 2.0,
                                    sparse_max_features = 80000,
                                    sparse_min_occurences = 5,
                                    calc_prob="sigmoid", n_jobs = 1,
                                    verbose = 0)}}{}

 \item{\code{--------------}}{}

 \item{\code{fit(x, y, sample_weight = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{predict(x)}}{}

 \item{\code{--------------}}{}

 \item{\code{predict_proba(x)}}{}

 \item{\code{--------------}}{}

 \item{\code{cleanup()}}{}

 \item{\code{--------------}}{}

 \item{\code{get_params(deep = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{score(x, y, sample_weight = NULL)}}{}

 \item{\code{--------------}}{}
 }
}

\examples{

try({
    if (reticulate::py_available(initialize = TRUE)) {
        if (reticulate::py_module_available("rgf.sklearn")) {

            library(RGF)

            set.seed(1)
            x = matrix(runif(100000), nrow = 100, ncol = 1000)

            y = sample(1:2, 100, replace = TRUE)

            fast_RGF_class = FastRGF_Classifier$new(max_leaf = 50)

            fast_RGF_class$fit(x, y)

            preds = fast_RGF_class$predict_proba(x)
        }
    }
}, silent=TRUE)
}
\references{
\emph{https://github.com/RGF-team/rgf/tree/master/python-package}, \emph{Tong Zhang, FastRGF: Multi-core Implementation of Regularized Greedy Forest (https://github.com/RGF-team/rgf/tree/master/FastRGF)}
}
\section{Super class}{
\code{\link[RGF:Internal_class]{RGF::Internal_class}} -> \code{FastRGF_Classifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FastRGF_Classifier$new()}}
\item \href{#method-clone}{\code{FastRGF_Classifier$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="cleanup">}\href{../../RGF/html/Internal_class.html#method-cleanup}{\code{RGF::Internal_class$cleanup()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="dump_model">}\href{../../RGF/html/Internal_class.html#method-dump_model}{\code{RGF::Internal_class$dump_model()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="feature_importances">}\href{../../RGF/html/Internal_class.html#method-feature_importances}{\code{RGF::Internal_class$feature_importances()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="fit">}\href{../../RGF/html/Internal_class.html#method-fit}{\code{RGF::Internal_class$fit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="get_params">}\href{../../RGF/html/Internal_class.html#method-get_params}{\code{RGF::Internal_class$get_params()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="predict">}\href{../../RGF/html/Internal_class.html#method-predict}{\code{RGF::Internal_class$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="predict_proba">}\href{../../RGF/html/Internal_class.html#method-predict_proba}{\code{RGF::Internal_class$predict_proba()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="save_model">}\href{../../RGF/html/Internal_class.html#method-save_model}{\code{RGF::Internal_class$save_model()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="score">}\href{../../RGF/html/Internal_class.html#method-score}{\code{RGF::Internal_class$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FastRGF_Classifier$new(
  n_estimators = 500,
  max_depth = 6,
  max_leaf = 50,
  tree_gain_ratio = 1,
  min_samples_leaf = 5,
  loss = "LS",
  l1 = 1,
  l2 = 1000,
  opt_algorithm = "rgf",
  learning_rate = 0.001,
  max_bin = NULL,
  min_child_weight = 5,
  data_l2 = 2,
  sparse_max_features = 80000,
  sparse_min_occurences = 5,
  calc_prob = "sigmoid",
  n_jobs = 1,
  verbose = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_estimators}}{an integer. The number of trees in the forest (Original name: forest.ntrees.)}

\item{\code{max_depth}}{an integer. Maximum tree depth (Original name: dtree.max_level.)}

\item{\code{max_leaf}}{an integer. Maximum number of leaf nodes in best-first search (Original name: dtree.max_nodes.)}

\item{\code{tree_gain_ratio}}{a float. New tree is created when leaf-nodes gain < this value * estimated gain of creating new tree (Original name: dtree.new_tree_gain_ratio.)}

\item{\code{min_samples_leaf}}{an integer or float. Minimum number of training data points in each leaf node. If an integer, then consider min_samples_leaf as the minimum number. If a float, then min_samples_leaf is a percentage and ceil(min_samples_leaf * n_samples) are the minimum number of samples for each node (Original name: dtree.min_sample.)}

\item{\code{loss}}{a character string. One of \emph{"LS"} (Least squares loss), \emph{"MODLS"} (Modified least squares loss) or \emph{"LOGISTIC"} (Logistic loss) (Original name: dtree.loss.)}

\item{\code{l1}}{a float. Used to control the degree of L1 regularization (Original name: dtree.lamL1.)}

\item{\code{l2}}{a float. Used to control the degree of L2 regularization (Original name: dtree.lamL2.)}

\item{\code{opt_algorithm}}{a character string. Either \emph{"rgf"} or \emph{"epsilon-greedy"}. Optimization method for training forest (Original name: forest.opt.)}

\item{\code{learning_rate}}{a float. Step size of epsilon-greedy boosting. Meant for being used with opt_algorithm = "epsilon-greedy" (Original name: forest.stepsize.)}

\item{\code{max_bin}}{an integer or NULL. Maximum number of discretized values (bins). If NULL, 65000 is used for dense data and 200 for sparse data (Original name: discretize.(sparse/dense).max_buckets.)}

\item{\code{min_child_weight}}{a float. Minimum sum of data weights for each discretized value (bin) (Original name: discretize.(sparse/dense).min_bucket_weights.)}

\item{\code{data_l2}}{a float. Used to control the degree of L2 regularization for discretization (Original name: discretize.(sparse/dense).lamL2.)}

\item{\code{sparse_max_features}}{an integer. Maximum number of selected features. Meant for being used with sparse data (Original name: discretize.sparse.max_features.)}

\item{\code{sparse_min_occurences}}{an integer. Minimum number of occurrences for a feature to be selected. Meant for being used with sparse data (Original name: discretize.sparse.min_occrrences.)}

\item{\code{calc_prob}}{a character string. Either \emph{"sigmoid"} or \emph{"softmax"}. Method of probability calculation}

\item{\code{n_jobs}}{an integer. The number of jobs to run in parallel for both fit and predict. If -1, all CPUs are used. If -2, all CPUs but one are used. If < -1, (n_cpus + 1 + n_jobs) are used (Original name: set.nthreads.)}

\item{\code{verbose}}{an integer. Controls the verbosity of the tree building process (Original name: set.verbose.)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FastRGF_Classifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
