% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rfpredinterval.R
\name{print.rfpredinterval}
\alias{print.rfpredinterval}
\title{Print summary output}
\usage{
\method{print}{rfpredinterval}(x, ...)
}
\arguments{
\item{x}{An object of class \code{('rfpredinterval', 'piall')},
\code{('rfpredinterval', 'pibf')}, or \code{('rfpredinterval', 'rfpi')}.}

\item{...}{Optional arguments to be passed to other methods.}
}
\description{
Print summary output from \code{pibf()}, \code{rfpi()}, or \code{piall()}
functions. This is the default print method for the package.
}
\examples{
## load example data
data(BostonHousing, package = "RFpredInterval")
set.seed(2345)

## define train/test split
testindex <- 1:10
trainindex <- sample(11:nrow(BostonHousing), size = 100, replace = FALSE)
traindata <- BostonHousing[trainindex, ]
testdata <- BostonHousing[testindex, ]
px <- ncol(BostonHousing) - 1

## construct 95\% PI with "cv" calibration using 5-folds
out <- pibf(formula = medv ~ ., traindata = traindata,
  testdata = testdata, calibration =  "oob",
  params_ranger = list(num.trees = 40))

## print summary output
print(out)

## contruct 95\% PI with "ls" split rule, "lm", "quant" and "spi" PI methods
## with calibration and use "ranger" package for RF training
out2 <- rfpi(formula = medv ~ ., traindata = traindata,
  testdata = testdata, split_rule = "ls", pi_method = c("lm", "quant", "spi"),
  rf_package = "ranger", params_ranger = list(num.trees = 50))

## print summary output
print(out2)

}
\seealso{
\code{\link{pibf}} \code{\link{piall}} \code{\link{rfpi}}
}
