% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significant.genes.R
\name{significant.genes}
\alias{significant.genes}
\title{significant.genes}
\usage{
significant.genes(
  object,
  imp,
  cutoff = 0.2,
  use_95_q = TRUE,
  do.plot = TRUE,
  debug.flag = 0
)
}
\arguments{
\item{object}{object retruned by run.it.importance}

\item{imp}{importances}

\item{cutoff}{cutoff}

\item{use_95_q}{use the 0.95 q value}

\item{do.plot}{do.plot either TRUE or FALSE (no plot)}

\item{debug.flag}{debug.flag  either 0 (no debugging information), 1 or 2}
}
\value{
A list containg
\itemize{
\item probabilities (from the fitted SN distribution) and names of the significant variables
\item the estimated FDR
}
}
\description{
This function sepects the significant "genes" and makes some plots
}
\examples{
data(imp20000)
imp <- log(imp20000$importances)
t2  <- imp20000$counts
plot(density((imp)))
hist(imp,col=6,lwd=2,breaks=100,main="histogram of importances")
res.temp <- determine_cutoff(imp, t2 ,cutoff=c(0,1,2,3),plot=c(0,1,2,3),Q=0.75,try.counter=1)
plot(c(0,1,2,3),res.temp[,3])
imp<-imp[t2 > 1]
qq <- plotQ(imp,debug.flag = 0)                                                          
ppp<-run.it.importances(qq,imp,debug=0)                                                       
aa<-significant.genes(ppp,imp,cutoff=0.2,debug.flag=0,do.plot=2, use_95_q=TRUE)                           
length(aa$probabilities) #11#                                                          
names(aa$probabilities)

\donttest{
library(RFlocalfdr.data)
data(ch22)                                                                                 
? ch22                                                                                     
plot(density(log(ch22$imp)))                                                               
t2 <-ch22$C                                                                                
imp<-log(ch22$imp)                                                                         
# Detemine a cutoff to get a unimodal density.                                              
# This may take several attempts. The default values of cutoff=c(0,1,4,10,15,20) will not find
# the minimum here.
#which occurs at 30
plot(c(25,30,35,40),res.temp[,3])                                                          
imp<-imp[t2 > 30]
qq <- plotQ(imp,debug.flag = 0)
ppp<-run.it.importances(qq,imp,debug=0)                                                       
aa<-significant.genes(ppp,imp,cutoff=0.2,debug.flag=0,do.plot=2)                           
length(aa$probabilities) # 6650                                                            
aa<-significant.genes(ppp,imp,cutoff=0.05,debug.flag=0,do.plot=2)                          
length(aa$probabilities) # 3653
}
}
\keyword{genes}
\keyword{significant}
