% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgreater_NIX.r
\name{pgreater_NIX}
\alias{pgreater_NIX}
\title{Calculate the Futility Stopping Probability for Continuous Endpoint with Unknown Variances Using a Normal-Inverse-Chi-Squared Distribution}
\usage{
pgreater_NIX(par1, par2, delta = 0, side, ...)
}
\arguments{
\item{par1}{current parameters including mu, kappa, nu, sigsq of a Normal-Inverse-Chi-Squared distribution from the control group.}

\item{par2}{current parameters including mu, kappa, nu, sigsq of a Normal-Inverse-Chi-Squared distribution from the compared treatment group.}

\item{delta}{pre-specified minimal effect size expected to be observed between the control group and the compared treatment group.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to stats::integrate() (such as rel.tol) from this function.}
}
\value{
a posterior probability of \eqn{Pr(\mu_k>\mu_{control}+\delta|data)} with \code{side} equals to 'upper';
a posterior probability of \eqn{Pr(\mu_{control}>\mu_k+\delta|data)} with \code{side} equals to 'lower'.
}
\description{
Calculate the futility stopping probability in Bayesian response-adaptive randomization with
a control group using the Thall \eqn{\&} Wathen method for continuous outcomes with unknown variances. The prior distributions
follow Normal-Inverse-Chi-Squared (NIX) distributions and can be specified individually for each treatment group.
}
\details{
This function calculates the results of \eqn{Pr(\mu_k>\mu_{control}+\delta|data)} for \code{side} equals to
'upper' and the results of \eqn{Pr(\mu_{control}>\mu_k+\delta|data)} for \code{side} equals to 'lower'.
The result indicates the posterior probability of stopping a treatment group due to futility around \eqn{1\%} in Bayesian
response-adaptive randomization with a control arm using Thall \eqn{\&} Wathen method, with accumulated results
during the conduct of trials. Parameters used in a Normal-Inverse-Gamma (\eqn{(\mu,\sigma^2) \sim NIG(mean=m,variance=V \times \sigma^2,shape=a,rate=b)})
distribution should be converted to parameters equivalent in a Normal-Inverse-Chi-Squared
(\eqn{(\mu,\sigma^2) \sim NIX(mean=\mu,effective sample size=\kappa,degrees of freedom=\nu,variance=\sigma^2/\kappa)})
distribution using \code{convert_gamma_to_chisq} before applying this function.
}
\examples{
para<-list(V=1/2,a=0.5,m=9.1/100,b=0.00002)
par<-convert_gamma_to_chisq(para)
set.seed(123451)
y1<-rnorm(100,0.091,0.009)
par1<-update_par_nichisq(y1, par)
set.seed(123452)
y2<-rnorm(90,0.09,0.009)
par2<-update_par_nichisq(y2, par)
pgreater_NIX(par1=par1,par2=par2, side='upper')
pgreater_NIX(par1=par1,par2=par2, side='lower')
}
\references{
\insertRef{Wathen2017}{RARtrials}
\insertRef{Kevin2007}{RARtrials}
}
